/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines recommendations for a Resilience Hub application component, returned as an object. This object contains
 * component names, configuration recommendations, and recommendation statuses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComponentRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<ComponentRecommendation.Builder, ComponentRecommendation> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentName").getter(getter(ComponentRecommendation::appComponentName))
            .setter(setter(Builder::appComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()).build();

    private static final SdkField<List<ConfigRecommendation>> CONFIG_RECOMMENDATIONS_FIELD = SdkField
            .<List<ConfigRecommendation>> builder(MarshallingType.LIST)
            .memberName("configRecommendations")
            .getter(getter(ComponentRecommendation::configRecommendations))
            .setter(setter(Builder::configRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationStatus").getter(getter(ComponentRecommendation::recommendationStatusAsString))
            .setter(setter(Builder::recommendationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD,
            CONFIG_RECOMMENDATIONS_FIELD, RECOMMENDATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appComponentName;

    private final List<ConfigRecommendation> configRecommendations;

    private final String recommendationStatus;

    private ComponentRecommendation(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.configRecommendations = builder.configRecommendations;
        this.recommendationStatus = builder.recommendationStatus;
    }

    /**
     * <p>
     * The name of the application component.
     * </p>
     * 
     * @return The name of the application component.
     */
    public final String appComponentName() {
        return appComponentName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigRecommendations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigRecommendations() {
        return configRecommendations != null && !(configRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of recommendations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigRecommendations} method.
     * </p>
     * 
     * @return The list of recommendations.
     */
    public final List<ConfigRecommendation> configRecommendations() {
        return configRecommendations;
    }

    /**
     * <p>
     * The recommendation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationStatus} will return {@link RecommendationComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationStatusAsString}.
     * </p>
     * 
     * @return The recommendation status.
     * @see RecommendationComplianceStatus
     */
    public final RecommendationComplianceStatus recommendationStatus() {
        return RecommendationComplianceStatus.fromValue(recommendationStatus);
    }

    /**
     * <p>
     * The recommendation status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationStatus} will return {@link RecommendationComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #recommendationStatusAsString}.
     * </p>
     * 
     * @return The recommendation status.
     * @see RecommendationComplianceStatus
     */
    public final String recommendationStatusAsString() {
        return recommendationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigRecommendations() ? configRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentRecommendation)) {
            return false;
        }
        ComponentRecommendation other = (ComponentRecommendation) obj;
        return Objects.equals(appComponentName(), other.appComponentName())
                && hasConfigRecommendations() == other.hasConfigRecommendations()
                && Objects.equals(configRecommendations(), other.configRecommendations())
                && Objects.equals(recommendationStatusAsString(), other.recommendationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComponentRecommendation").add("AppComponentName", appComponentName())
                .add("ConfigRecommendations", hasConfigRecommendations() ? configRecommendations() : null)
                .add("RecommendationStatus", recommendationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appComponentName":
            return Optional.ofNullable(clazz.cast(appComponentName()));
        case "configRecommendations":
            return Optional.ofNullable(clazz.cast(configRecommendations()));
        case "recommendationStatus":
            return Optional.ofNullable(clazz.cast(recommendationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComponentRecommendation, T> g) {
        return obj -> g.apply((ComponentRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComponentRecommendation> {
        /**
         * <p>
         * The name of the application component.
         * </p>
         * 
         * @param appComponentName
         *        The name of the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentName(String appComponentName);

        /**
         * <p>
         * The list of recommendations.
         * </p>
         * 
         * @param configRecommendations
         *        The list of recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRecommendations(Collection<ConfigRecommendation> configRecommendations);

        /**
         * <p>
         * The list of recommendations.
         * </p>
         * 
         * @param configRecommendations
         *        The list of recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configRecommendations(ConfigRecommendation... configRecommendations);

        /**
         * <p>
         * The list of recommendations.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ConfigRecommendation>.Builder}
         * avoiding the need to create one manually via {@link List<ConfigRecommendation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ConfigRecommendation>.Builder#build()} is called immediately
         * and its result is passed to {@link #configRecommendations(List<ConfigRecommendation>)}.
         * 
         * @param configRecommendations
         *        a consumer that will call methods on {@link List<ConfigRecommendation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configRecommendations(List<ConfigRecommendation>)
         */
        Builder configRecommendations(Consumer<ConfigRecommendation.Builder>... configRecommendations);

        /**
         * <p>
         * The recommendation status.
         * </p>
         * 
         * @param recommendationStatus
         *        The recommendation status.
         * @see RecommendationComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationComplianceStatus
         */
        Builder recommendationStatus(String recommendationStatus);

        /**
         * <p>
         * The recommendation status.
         * </p>
         * 
         * @param recommendationStatus
         *        The recommendation status.
         * @see RecommendationComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationComplianceStatus
         */
        Builder recommendationStatus(RecommendationComplianceStatus recommendationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String appComponentName;

        private List<ConfigRecommendation> configRecommendations = DefaultSdkAutoConstructList.getInstance();

        private String recommendationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentRecommendation model) {
            appComponentName(model.appComponentName);
            configRecommendations(model.configRecommendations);
            recommendationStatus(model.recommendationStatus);
        }

        public final String getAppComponentName() {
            return appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final List<ConfigRecommendation.Builder> getConfigRecommendations() {
            List<ConfigRecommendation.Builder> result = ConfigRecommendationListCopier.copyToBuilder(this.configRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigRecommendations(Collection<ConfigRecommendation.BuilderImpl> configRecommendations) {
            this.configRecommendations = ConfigRecommendationListCopier.copyFromBuilder(configRecommendations);
        }

        @Override
        public final Builder configRecommendations(Collection<ConfigRecommendation> configRecommendations) {
            this.configRecommendations = ConfigRecommendationListCopier.copy(configRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRecommendations(ConfigRecommendation... configRecommendations) {
            configRecommendations(Arrays.asList(configRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configRecommendations(Consumer<ConfigRecommendation.Builder>... configRecommendations) {
            configRecommendations(Stream.of(configRecommendations)
                    .map(c -> ConfigRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationStatus() {
            return recommendationStatus;
        }

        public final void setRecommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
        }

        @Override
        public final Builder recommendationStatus(String recommendationStatus) {
            this.recommendationStatus = recommendationStatus;
            return this;
        }

        @Override
        public final Builder recommendationStatus(RecommendationComplianceStatus recommendationStatus) {
            this.recommendationStatus(recommendationStatus == null ? null : recommendationStatus.toString());
            return this;
        }

        @Override
        public ComponentRecommendation build() {
            return new ComponentRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
