/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportResourcesToDraftAppVersionRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<ImportResourcesToDraftAppVersionRequest.Builder, ImportResourcesToDraftAppVersionRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(ImportResourcesToDraftAppVersionRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<List<String>> SOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceArns")
            .getter(getter(ImportResourcesToDraftAppVersionRequest::sourceArns))
            .setter(setter(Builder::sourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TerraformSource>> TERRAFORM_SOURCES_FIELD = SdkField
            .<List<TerraformSource>> builder(MarshallingType.LIST)
            .memberName("terraformSources")
            .getter(getter(ImportResourcesToDraftAppVersionRequest::terraformSources))
            .setter(setter(Builder::terraformSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TerraformSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TerraformSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            SOURCE_ARNS_FIELD, TERRAFORM_SOURCES_FIELD));

    private final String appArn;

    private final List<String> sourceArns;

    private final List<TerraformSource> terraformSources;

    private ImportResourcesToDraftAppVersionRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.sourceArns = builder.sourceArns;
        this.terraformSources = builder.terraformSources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information
     *         about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     *         Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSourceArns() {
        return sourceArns != null && !(sourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources that you want to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for the resources that you want to import.
     */
    public final List<String> sourceArns() {
        return sourceArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerraformSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerraformSources() {
        return terraformSources != null && !(terraformSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of terraform file s3 URLs you need to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerraformSources} method.
     * </p>
     * 
     * @return A list of terraform file s3 URLs you need to import.
     */
    public final List<TerraformSource> terraformSources() {
        return terraformSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceArns() ? sourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTerraformSources() ? terraformSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourcesToDraftAppVersionRequest)) {
            return false;
        }
        ImportResourcesToDraftAppVersionRequest other = (ImportResourcesToDraftAppVersionRequest) obj;
        return Objects.equals(appArn(), other.appArn()) && hasSourceArns() == other.hasSourceArns()
                && Objects.equals(sourceArns(), other.sourceArns()) && hasTerraformSources() == other.hasTerraformSources()
                && Objects.equals(terraformSources(), other.terraformSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportResourcesToDraftAppVersionRequest").add("AppArn", appArn())
                .add("SourceArns", hasSourceArns() ? sourceArns() : null)
                .add("TerraformSources", hasTerraformSources() ? terraformSources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "sourceArns":
            return Optional.ofNullable(clazz.cast(sourceArns()));
        case "terraformSources":
            return Optional.ofNullable(clazz.cast(terraformSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportResourcesToDraftAppVersionRequest, T> g) {
        return obj -> g.apply((ImportResourcesToDraftAppVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportResourcesToDraftAppVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about
         * ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the resources that you want to import.
         * </p>
         * 
         * @param sourceArns
         *        The Amazon Resource Names (ARNs) for the resources that you want to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArns(Collection<String> sourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the resources that you want to import.
         * </p>
         * 
         * @param sourceArns
         *        The Amazon Resource Names (ARNs) for the resources that you want to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArns(String... sourceArns);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * 
         * @param terraformSources
         *        A list of terraform file s3 URLs you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSources(Collection<TerraformSource> terraformSources);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * 
         * @param terraformSources
         *        A list of terraform file s3 URLs you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSources(TerraformSource... terraformSources);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TerraformSource>.Builder} avoiding
         * the need to create one manually via {@link List<TerraformSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TerraformSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #terraformSources(List<TerraformSource>)}.
         * 
         * @param terraformSources
         *        a consumer that will call methods on {@link List<TerraformSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terraformSources(List<TerraformSource>)
         */
        Builder terraformSources(Consumer<TerraformSource.Builder>... terraformSources);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private List<String> sourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<TerraformSource> terraformSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourcesToDraftAppVersionRequest model) {
            super(model);
            appArn(model.appArn);
            sourceArns(model.sourceArns);
            terraformSources(model.terraformSources);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final Collection<String> getSourceArns() {
            if (sourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceArns;
        }

        public final void setSourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
        }

        @Override
        public final Builder sourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceArns(String... sourceArns) {
            sourceArns(Arrays.asList(sourceArns));
            return this;
        }

        public final List<TerraformSource.Builder> getTerraformSources() {
            List<TerraformSource.Builder> result = TerraformSourceListCopier.copyToBuilder(this.terraformSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerraformSources(Collection<TerraformSource.BuilderImpl> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copyFromBuilder(terraformSources);
        }

        @Override
        public final Builder terraformSources(Collection<TerraformSource> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copy(terraformSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(TerraformSource... terraformSources) {
            terraformSources(Arrays.asList(terraformSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(Consumer<TerraformSource.Builder>... terraformSources) {
            terraformSources(Stream.of(terraformSources).map(c -> TerraformSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportResourcesToDraftAppVersionRequest build() {
            return new ImportResourcesToDraftAppVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
