/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppVersionResourcesResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListAppVersionResourcesResponse.Builder, ListAppVersionResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppVersionResourcesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PhysicalResource>> PHYSICAL_RESOURCES_FIELD = SdkField
            .<List<PhysicalResource>> builder(MarshallingType.LIST)
            .memberName("physicalResources")
            .getter(getter(ListAppVersionResourcesResponse::physicalResources))
            .setter(setter(Builder::physicalResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhysicalResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhysicalResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOLUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolutionId").getter(getter(ListAppVersionResourcesResponse::resolutionId))
            .setter(setter(Builder::resolutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PHYSICAL_RESOURCES_FIELD, RESOLUTION_ID_FIELD));

    private final String nextToken;

    private final List<PhysicalResource> physicalResources;

    private final String resolutionId;

    private ListAppVersionResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.physicalResources = builder.physicalResources;
        this.resolutionId = builder.resolutionId;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhysicalResources property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhysicalResources() {
        return physicalResources != null && !(physicalResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The physical resources in the application version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhysicalResources} method.
     * </p>
     * 
     * @return The physical resources in the application version.
     */
    public final List<PhysicalResource> physicalResources() {
        return physicalResources;
    }

    /**
     * <p>
     * The identifier for a specific resolution.
     * </p>
     * 
     * @return The identifier for a specific resolution.
     */
    public final String resolutionId() {
        return resolutionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasPhysicalResources() ? physicalResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resolutionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionResourcesResponse)) {
            return false;
        }
        ListAppVersionResourcesResponse other = (ListAppVersionResourcesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasPhysicalResources() == other.hasPhysicalResources()
                && Objects.equals(physicalResources(), other.physicalResources())
                && Objects.equals(resolutionId(), other.resolutionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppVersionResourcesResponse").add("NextToken", nextToken())
                .add("PhysicalResources", hasPhysicalResources() ? physicalResources() : null)
                .add("ResolutionId", resolutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "physicalResources":
            return Optional.ofNullable(clazz.cast(physicalResources()));
        case "resolutionId":
            return Optional.ofNullable(clazz.cast(resolutionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionResourcesResponse, T> g) {
        return obj -> g.apply((ListAppVersionResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAppVersionResourcesResponse> {
        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The physical resources in the application version.
         * </p>
         * 
         * @param physicalResources
         *        The physical resources in the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResources(Collection<PhysicalResource> physicalResources);

        /**
         * <p>
         * The physical resources in the application version.
         * </p>
         * 
         * @param physicalResources
         *        The physical resources in the application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResources(PhysicalResource... physicalResources);

        /**
         * <p>
         * The physical resources in the application version.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PhysicalResource>.Builder} avoiding
         * the need to create one manually via {@link List<PhysicalResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhysicalResource>.Builder#build()} is called immediately and
         * its result is passed to {@link #physicalResources(List<PhysicalResource>)}.
         * 
         * @param physicalResources
         *        a consumer that will call methods on {@link List<PhysicalResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalResources(List<PhysicalResource>)
         */
        Builder physicalResources(Consumer<PhysicalResource.Builder>... physicalResources);

        /**
         * <p>
         * The identifier for a specific resolution.
         * </p>
         * 
         * @param resolutionId
         *        The identifier for a specific resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolutionId(String resolutionId);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PhysicalResource> physicalResources = DefaultSdkAutoConstructList.getInstance();

        private String resolutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionResourcesResponse model) {
            super(model);
            nextToken(model.nextToken);
            physicalResources(model.physicalResources);
            resolutionId(model.resolutionId);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PhysicalResource.Builder> getPhysicalResources() {
            List<PhysicalResource.Builder> result = PhysicalResourceListCopier.copyToBuilder(this.physicalResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhysicalResources(Collection<PhysicalResource.BuilderImpl> physicalResources) {
            this.physicalResources = PhysicalResourceListCopier.copyFromBuilder(physicalResources);
        }

        @Override
        public final Builder physicalResources(Collection<PhysicalResource> physicalResources) {
            this.physicalResources = PhysicalResourceListCopier.copy(physicalResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalResources(PhysicalResource... physicalResources) {
            physicalResources(Arrays.asList(physicalResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalResources(Consumer<PhysicalResource.Builder>... physicalResources) {
            physicalResources(Stream.of(physicalResources).map(c -> PhysicalResource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResolutionId() {
            return resolutionId;
        }

        public final void setResolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
        }

        @Override
        public final Builder resolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
            return this;
        }

        @Override
        public ListAppVersionResourcesResponse build() {
            return new ListAppVersionResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
