/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveDraftAppVersionResourceMappingsRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<RemoveDraftAppVersionResourceMappingsRequest.Builder, RemoveDraftAppVersionResourceMappingsRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(RemoveDraftAppVersionResourceMappingsRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<List<String>> APP_REGISTRY_APP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("appRegistryAppNames")
            .getter(getter(RemoveDraftAppVersionResourceMappingsRequest::appRegistryAppNames))
            .setter(setter(Builder::appRegistryAppNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appRegistryAppNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOGICAL_STACK_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logicalStackNames")
            .getter(getter(RemoveDraftAppVersionResourceMappingsRequest::logicalStackNames))
            .setter(setter(Builder::logicalStackNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceGroupNames")
            .getter(getter(RemoveDraftAppVersionResourceMappingsRequest::resourceGroupNames))
            .setter(setter(Builder::resourceGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceNames")
            .getter(getter(RemoveDraftAppVersionResourceMappingsRequest::resourceNames))
            .setter(setter(Builder::resourceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TERRAFORM_SOURCE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("terraformSourceNames")
            .getter(getter(RemoveDraftAppVersionResourceMappingsRequest::terraformSourceNames))
            .setter(setter(Builder::terraformSourceNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSourceNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_REGISTRY_APP_NAMES_FIELD, LOGICAL_STACK_NAMES_FIELD, RESOURCE_GROUP_NAMES_FIELD, RESOURCE_NAMES_FIELD,
            TERRAFORM_SOURCE_NAMES_FIELD));

    private final String appArn;

    private final List<String> appRegistryAppNames;

    private final List<String> logicalStackNames;

    private final List<String> resourceGroupNames;

    private final List<String> resourceNames;

    private final List<String> terraformSourceNames;

    private RemoveDraftAppVersionResourceMappingsRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appRegistryAppNames = builder.appRegistryAppNames;
        this.logicalStackNames = builder.logicalStackNames;
        this.resourceGroupNames = builder.resourceGroupNames;
        this.resourceNames = builder.resourceNames;
        this.terraformSourceNames = builder.terraformSourceNames;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information
     *         about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     *         Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppRegistryAppNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppRegistryAppNames() {
        return appRegistryAppNames != null && !(appRegistryAppNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the registered applications to remove from the resource mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppRegistryAppNames} method.
     * </p>
     * 
     * @return The names of the registered applications to remove from the resource mappings.
     */
    public final List<String> appRegistryAppNames() {
        return appRegistryAppNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogicalStackNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogicalStackNames() {
        return logicalStackNames != null && !(logicalStackNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the CloudFormation stacks to remove from the resource mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogicalStackNames} method.
     * </p>
     * 
     * @return The names of the CloudFormation stacks to remove from the resource mappings.
     */
    public final List<String> logicalStackNames() {
        return logicalStackNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceGroupNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceGroupNames() {
        return resourceGroupNames != null && !(resourceGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the resource groups to remove from the resource mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceGroupNames} method.
     * </p>
     * 
     * @return The names of the resource groups to remove from the resource mappings.
     */
    public final List<String> resourceGroupNames() {
        return resourceGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceNames() {
        return resourceNames != null && !(resourceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the resources to remove from the resource mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceNames} method.
     * </p>
     * 
     * @return The names of the resources to remove from the resource mappings.
     */
    public final List<String> resourceNames() {
        return resourceNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerraformSourceNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerraformSourceNames() {
        return terraformSourceNames != null && !(terraformSourceNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * 
     * <pre>
     * <code>&lt;/p&gt; </code>
     * </pre>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerraformSourceNames} method.
     * </p>
     * 
     * @return <pre><code>&lt;/p&gt; </code>
     */
    public final List<String> terraformSourceNames() {
        return terraformSourceNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppRegistryAppNames() ? appRegistryAppNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogicalStackNames() ? logicalStackNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceGroupNames() ? resourceGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceNames() ? resourceNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTerraformSourceNames() ? terraformSourceNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveDraftAppVersionResourceMappingsRequest)) {
            return false;
        }
        RemoveDraftAppVersionResourceMappingsRequest other = (RemoveDraftAppVersionResourceMappingsRequest) obj;
        return Objects.equals(appArn(), other.appArn()) && hasAppRegistryAppNames() == other.hasAppRegistryAppNames()
                && Objects.equals(appRegistryAppNames(), other.appRegistryAppNames())
                && hasLogicalStackNames() == other.hasLogicalStackNames()
                && Objects.equals(logicalStackNames(), other.logicalStackNames())
                && hasResourceGroupNames() == other.hasResourceGroupNames()
                && Objects.equals(resourceGroupNames(), other.resourceGroupNames())
                && hasResourceNames() == other.hasResourceNames() && Objects.equals(resourceNames(), other.resourceNames())
                && hasTerraformSourceNames() == other.hasTerraformSourceNames()
                && Objects.equals(terraformSourceNames(), other.terraformSourceNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveDraftAppVersionResourceMappingsRequest").add("AppArn", appArn())
                .add("AppRegistryAppNames", hasAppRegistryAppNames() ? appRegistryAppNames() : null)
                .add("LogicalStackNames", hasLogicalStackNames() ? logicalStackNames() : null)
                .add("ResourceGroupNames", hasResourceGroupNames() ? resourceGroupNames() : null)
                .add("ResourceNames", hasResourceNames() ? resourceNames() : null)
                .add("TerraformSourceNames", hasTerraformSourceNames() ? terraformSourceNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appRegistryAppNames":
            return Optional.ofNullable(clazz.cast(appRegistryAppNames()));
        case "logicalStackNames":
            return Optional.ofNullable(clazz.cast(logicalStackNames()));
        case "resourceGroupNames":
            return Optional.ofNullable(clazz.cast(resourceGroupNames()));
        case "resourceNames":
            return Optional.ofNullable(clazz.cast(resourceNames()));
        case "terraformSourceNames":
            return Optional.ofNullable(clazz.cast(terraformSourceNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveDraftAppVersionResourceMappingsRequest, T> g) {
        return obj -> g.apply((RemoveDraftAppVersionResourceMappingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RemoveDraftAppVersionResourceMappingsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about
         * ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The names of the registered applications to remove from the resource mappings.
         * </p>
         * 
         * @param appRegistryAppNames
         *        The names of the registered applications to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appRegistryAppNames(Collection<String> appRegistryAppNames);

        /**
         * <p>
         * The names of the registered applications to remove from the resource mappings.
         * </p>
         * 
         * @param appRegistryAppNames
         *        The names of the registered applications to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appRegistryAppNames(String... appRegistryAppNames);

        /**
         * <p>
         * The names of the CloudFormation stacks to remove from the resource mappings.
         * </p>
         * 
         * @param logicalStackNames
         *        The names of the CloudFormation stacks to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalStackNames(Collection<String> logicalStackNames);

        /**
         * <p>
         * The names of the CloudFormation stacks to remove from the resource mappings.
         * </p>
         * 
         * @param logicalStackNames
         *        The names of the CloudFormation stacks to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalStackNames(String... logicalStackNames);

        /**
         * <p>
         * The names of the resource groups to remove from the resource mappings.
         * </p>
         * 
         * @param resourceGroupNames
         *        The names of the resource groups to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupNames(Collection<String> resourceGroupNames);

        /**
         * <p>
         * The names of the resource groups to remove from the resource mappings.
         * </p>
         * 
         * @param resourceGroupNames
         *        The names of the resource groups to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGroupNames(String... resourceGroupNames);

        /**
         * <p>
         * The names of the resources to remove from the resource mappings.
         * </p>
         * 
         * @param resourceNames
         *        The names of the resources to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceNames(Collection<String> resourceNames);

        /**
         * <p>
         * The names of the resources to remove from the resource mappings.
         * </p>
         * 
         * @param resourceNames
         *        The names of the resources to remove from the resource mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceNames(String... resourceNames);

        /**
         * <p>
         * 
         * <pre>
         * <code>&lt;/p&gt; </code>
         * </pre>
         * 
         * @param terraformSourceNames
         *        <pre>
         * 
         *        <code>&lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder terraformSourceNames(Collection<String> terraformSourceNames);

        /**
         * <p>
         * 
         * <pre>
         * <code>&lt;/p&gt; </code>
         * </pre>
         * 
         * @param terraformSourceNames
         *        <pre>
         * 
         *        <code>&lt;/p&gt; </code> @return Returns a reference to this object so that method calls can be
         *        chained together.
         */
        Builder terraformSourceNames(String... terraformSourceNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private List<String> appRegistryAppNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> logicalStackNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> terraformSourceNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveDraftAppVersionResourceMappingsRequest model) {
            super(model);
            appArn(model.appArn);
            appRegistryAppNames(model.appRegistryAppNames);
            logicalStackNames(model.logicalStackNames);
            resourceGroupNames(model.resourceGroupNames);
            resourceNames(model.resourceNames);
            terraformSourceNames(model.terraformSourceNames);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final Collection<String> getAppRegistryAppNames() {
            if (appRegistryAppNames instanceof SdkAutoConstructList) {
                return null;
            }
            return appRegistryAppNames;
        }

        public final void setAppRegistryAppNames(Collection<String> appRegistryAppNames) {
            this.appRegistryAppNames = EntityNameListCopier.copy(appRegistryAppNames);
        }

        @Override
        public final Builder appRegistryAppNames(Collection<String> appRegistryAppNames) {
            this.appRegistryAppNames = EntityNameListCopier.copy(appRegistryAppNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appRegistryAppNames(String... appRegistryAppNames) {
            appRegistryAppNames(Arrays.asList(appRegistryAppNames));
            return this;
        }

        public final Collection<String> getLogicalStackNames() {
            if (logicalStackNames instanceof SdkAutoConstructList) {
                return null;
            }
            return logicalStackNames;
        }

        public final void setLogicalStackNames(Collection<String> logicalStackNames) {
            this.logicalStackNames = String255ListCopier.copy(logicalStackNames);
        }

        @Override
        public final Builder logicalStackNames(Collection<String> logicalStackNames) {
            this.logicalStackNames = String255ListCopier.copy(logicalStackNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logicalStackNames(String... logicalStackNames) {
            logicalStackNames(Arrays.asList(logicalStackNames));
            return this;
        }

        public final Collection<String> getResourceGroupNames() {
            if (resourceGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceGroupNames;
        }

        public final void setResourceGroupNames(Collection<String> resourceGroupNames) {
            this.resourceGroupNames = EntityNameListCopier.copy(resourceGroupNames);
        }

        @Override
        public final Builder resourceGroupNames(Collection<String> resourceGroupNames) {
            this.resourceGroupNames = EntityNameListCopier.copy(resourceGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceGroupNames(String... resourceGroupNames) {
            resourceGroupNames(Arrays.asList(resourceGroupNames));
            return this;
        }

        public final Collection<String> getResourceNames() {
            if (resourceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceNames;
        }

        public final void setResourceNames(Collection<String> resourceNames) {
            this.resourceNames = EntityNameListCopier.copy(resourceNames);
        }

        @Override
        public final Builder resourceNames(Collection<String> resourceNames) {
            this.resourceNames = EntityNameListCopier.copy(resourceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceNames(String... resourceNames) {
            resourceNames(Arrays.asList(resourceNames));
            return this;
        }

        public final Collection<String> getTerraformSourceNames() {
            if (terraformSourceNames instanceof SdkAutoConstructList) {
                return null;
            }
            return terraformSourceNames;
        }

        public final void setTerraformSourceNames(Collection<String> terraformSourceNames) {
            this.terraformSourceNames = String255ListCopier.copy(terraformSourceNames);
        }

        @Override
        public final Builder terraformSourceNames(Collection<String> terraformSourceNames) {
            this.terraformSourceNames = String255ListCopier.copy(terraformSourceNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSourceNames(String... terraformSourceNames) {
            terraformSourceNames(Arrays.asList(terraformSourceNames));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveDraftAppVersionResourceMappingsRequest build() {
            return new RemoveDraftAppVersionResourceMappingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
