/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResiliencyPolicyRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<UpdateResiliencyPolicyRequest.Builder, UpdateResiliencyPolicyRequest> {
    private static final SdkField<String> DATA_LOCATION_CONSTRAINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataLocationConstraint").getter(getter(UpdateResiliencyPolicyRequest::dataLocationConstraintAsString))
            .setter(setter(Builder::dataLocationConstraint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataLocationConstraint").build())
            .build();

    private static final SdkField<Map<String, FailurePolicy>> POLICY_FIELD = SdkField
            .<Map<String, FailurePolicy>> builder(MarshallingType.MAP)
            .memberName("policy")
            .getter(getter(UpdateResiliencyPolicyRequest::policyAsStrings))
            .setter(setter(Builder::policyWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<FailurePolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailurePolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(UpdateResiliencyPolicyRequest::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<String> POLICY_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDescription").getter(getter(UpdateResiliencyPolicyRequest::policyDescription))
            .setter(setter(Builder::policyDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDescription").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(UpdateResiliencyPolicyRequest::policyName))
            .setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("tier")
            .getter(getter(UpdateResiliencyPolicyRequest::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_LOCATION_CONSTRAINT_FIELD, POLICY_FIELD, POLICY_ARN_FIELD, POLICY_DESCRIPTION_FIELD, POLICY_NAME_FIELD,
            TIER_FIELD));

    private final String dataLocationConstraint;

    private final Map<String, FailurePolicy> policy;

    private final String policyArn;

    private final String policyDescription;

    private final String policyName;

    private final String tier;

    private UpdateResiliencyPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.dataLocationConstraint = builder.dataLocationConstraint;
        this.policy = builder.policy;
        this.policyArn = builder.policyArn;
        this.policyDescription = builder.policyDescription;
        this.policyName = builder.policyName;
        this.tier = builder.tier;
    }

    /**
     * <p>
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataLocationConstraint} will return {@link DataLocationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataLocationConstraintAsString}.
     * </p>
     * 
     * @return Specifies a high-level geographical location constraint for where your resilience policy data can be
     *         stored.
     * @see DataLocationConstraint
     */
    public final DataLocationConstraint dataLocationConstraint() {
        return DataLocationConstraint.fromValue(dataLocationConstraint);
    }

    /**
     * <p>
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataLocationConstraint} will return {@link DataLocationConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataLocationConstraintAsString}.
     * </p>
     * 
     * @return Specifies a high-level geographical location constraint for where your resilience policy data can be
     *         stored.
     * @see DataLocationConstraint
     */
    public final String dataLocationConstraintAsString() {
        return dataLocationConstraint;
    }

    /**
     * <p>
     * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
     * objective (RPO) in seconds.
     * </p>
     * <note>
     * <p>
     * If you do not want to specify regional targets for a regional policy, you must set the values of
     * <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicy} method.
     * </p>
     * 
     * @return The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
     *         point objective (RPO) in seconds.</p> <note>
     *         <p>
     *         If you do not want to specify regional targets for a regional policy, you must set the values of
     *         <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
     *         </p>
     */
    public final Map<DisruptionType, FailurePolicy> policy() {
        return DisruptionPolicyCopier.copyStringToEnum(policy);
    }

    /**
     * For responses, this returns true if the service returned a value for the Policy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPolicy() {
        return policy != null && !(policy instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
     * objective (RPO) in seconds.
     * </p>
     * <note>
     * <p>
     * If you do not want to specify regional targets for a regional policy, you must set the values of
     * <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPolicy} method.
     * </p>
     * 
     * @return The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
     *         point objective (RPO) in seconds.</p> <note>
     *         <p>
     *         If you do not want to specify regional targets for a regional policy, you must set the values of
     *         <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
     *         </p>
     */
    public final Map<String, FailurePolicy> policyAsStrings() {
        return policy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
     *         <code>policy-id</code>. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The description for the policy.
     * </p>
     * 
     * @return The description for the policy.
     */
    public final String policyDescription() {
        return policyDescription;
    }

    /**
     * <p>
     * The name of the policy
     * </p>
     * 
     * @return The name of the policy
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (
     * <code>NonCritical</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link ResiliencyPolicyTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
     *         lowest (<code>NonCritical</code>).
     * @see ResiliencyPolicyTier
     */
    public final ResiliencyPolicyTier tier() {
        return ResiliencyPolicyTier.fromValue(tier);
    }

    /**
     * <p>
     * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to lowest (
     * <code>NonCritical</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link ResiliencyPolicyTier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
     *         lowest (<code>NonCritical</code>).
     * @see ResiliencyPolicyTier
     */
    public final String tierAsString() {
        return tier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataLocationConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPolicy() ? policyAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyDescription());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResiliencyPolicyRequest)) {
            return false;
        }
        UpdateResiliencyPolicyRequest other = (UpdateResiliencyPolicyRequest) obj;
        return Objects.equals(dataLocationConstraintAsString(), other.dataLocationConstraintAsString())
                && hasPolicy() == other.hasPolicy() && Objects.equals(policyAsStrings(), other.policyAsStrings())
                && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(policyDescription(), other.policyDescription())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(tierAsString(), other.tierAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResiliencyPolicyRequest").add("DataLocationConstraint", dataLocationConstraintAsString())
                .add("Policy", hasPolicy() ? policyAsStrings() : null).add("PolicyArn", policyArn())
                .add("PolicyDescription", policyDescription()).add("PolicyName", policyName()).add("Tier", tierAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataLocationConstraint":
            return Optional.ofNullable(clazz.cast(dataLocationConstraintAsString()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policyAsStrings()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "policyDescription":
            return Optional.ofNullable(clazz.cast(policyDescription()));
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResiliencyPolicyRequest, T> g) {
        return obj -> g.apply((UpdateResiliencyPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResiliencyPolicyRequest> {
        /**
         * <p>
         * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
         * </p>
         * 
         * @param dataLocationConstraint
         *        Specifies a high-level geographical location constraint for where your resilience policy data can be
         *        stored.
         * @see DataLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLocationConstraint
         */
        Builder dataLocationConstraint(String dataLocationConstraint);

        /**
         * <p>
         * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
         * </p>
         * 
         * @param dataLocationConstraint
         *        Specifies a high-level geographical location constraint for where your resilience policy data can be
         *        stored.
         * @see DataLocationConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLocationConstraint
         */
        Builder dataLocationConstraint(DataLocationConstraint dataLocationConstraint);

        /**
         * <p>
         * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
         * objective (RPO) in seconds.
         * </p>
         * <note>
         * <p>
         * If you do not want to specify regional targets for a regional policy, you must set the values of
         * <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
         * </p>
         * </note>
         * 
         * @param policy
         *        The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
         *        point objective (RPO) in seconds.</p> <note>
         *        <p>
         *        If you do not want to specify regional targets for a regional policy, you must set the values of
         *        <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyWithStrings(Map<String, FailurePolicy> policy);

        /**
         * <p>
         * The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery point
         * objective (RPO) in seconds.
         * </p>
         * <note>
         * <p>
         * If you do not want to specify regional targets for a regional policy, you must set the values of
         * <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
         * </p>
         * </note>
         * 
         * @param policy
         *        The type of resiliency policy to be created, including the recovery time objective (RTO) and recovery
         *        point objective (RPO) in seconds.</p> <note>
         *        <p>
         *        If you do not want to specify regional targets for a regional policy, you must set the values of
         *        <code>rpoInSecs</code> and <code>rtoInSecs</code> to <code>-1</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(Map<DisruptionType, FailurePolicy> policy);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
         * <code>policy-id</code>. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
         *        <code>policy-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The description for the policy.
         * </p>
         * 
         * @param policyDescription
         *        The description for the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDescription(String policyDescription);

        /**
         * <p>
         * The name of the policy
         * </p>
         * 
         * @param policyName
         *        The name of the policy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
         * lowest (<code>NonCritical</code>).
         * </p>
         * 
         * @param tier
         *        The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>)
         *        to lowest (<code>NonCritical</code>).
         * @see ResiliencyPolicyTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResiliencyPolicyTier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>) to
         * lowest (<code>NonCritical</code>).
         * </p>
         * 
         * @param tier
         *        The tier for this resiliency policy, ranging from the highest severity (<code>MissionCritical</code>)
         *        to lowest (<code>NonCritical</code>).
         * @see ResiliencyPolicyTier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResiliencyPolicyTier
         */
        Builder tier(ResiliencyPolicyTier tier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String dataLocationConstraint;

        private Map<String, FailurePolicy> policy = DefaultSdkAutoConstructMap.getInstance();

        private String policyArn;

        private String policyDescription;

        private String policyName;

        private String tier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResiliencyPolicyRequest model) {
            super(model);
            dataLocationConstraint(model.dataLocationConstraint);
            policyWithStrings(model.policy);
            policyArn(model.policyArn);
            policyDescription(model.policyDescription);
            policyName(model.policyName);
            tier(model.tier);
        }

        public final String getDataLocationConstraint() {
            return dataLocationConstraint;
        }

        public final void setDataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
        }

        @Override
        public final Builder dataLocationConstraint(String dataLocationConstraint) {
            this.dataLocationConstraint = dataLocationConstraint;
            return this;
        }

        @Override
        public final Builder dataLocationConstraint(DataLocationConstraint dataLocationConstraint) {
            this.dataLocationConstraint(dataLocationConstraint == null ? null : dataLocationConstraint.toString());
            return this;
        }

        public final Map<String, FailurePolicy.Builder> getPolicy() {
            Map<String, FailurePolicy.Builder> result = DisruptionPolicyCopier.copyToBuilder(this.policy);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPolicy(Map<String, FailurePolicy.BuilderImpl> policy) {
            this.policy = DisruptionPolicyCopier.copyFromBuilder(policy);
        }

        @Override
        public final Builder policyWithStrings(Map<String, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copy(policy);
            return this;
        }

        @Override
        public final Builder policy(Map<DisruptionType, FailurePolicy> policy) {
            this.policy = DisruptionPolicyCopier.copyEnumToString(policy);
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyDescription() {
            return policyDescription;
        }

        public final void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        @Override
        public final Builder policyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(ResiliencyPolicyTier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResiliencyPolicyRequest build() {
            return new UpdateResiliencyPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
