/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRecommendationTemplateRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<DeleteRecommendationTemplateRequest.Builder, DeleteRecommendationTemplateRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteRecommendationTemplateRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RECOMMENDATION_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationTemplateArn")
            .getter(getter(DeleteRecommendationTemplateRequest::recommendationTemplateArn))
            .setter(setter(Builder::recommendationTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTemplateArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            RECOMMENDATION_TEMPLATE_ARN_FIELD));

    private final String clientToken;

    private final String recommendationTemplateArn;

    private DeleteRecommendationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.recommendationTemplateArn = builder.recommendationTemplateArn;
    }

    /**
     * <p>
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
     * You should not reuse the same client token for other API requests.
     * </p>
     * 
     * @return Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
     *         characters. You should not reuse the same client token for other API requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a recommendation template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a recommendation template.
     */
    public final String recommendationTemplateArn() {
        return recommendationTemplateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTemplateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecommendationTemplateRequest)) {
            return false;
        }
        DeleteRecommendationTemplateRequest other = (DeleteRecommendationTemplateRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(recommendationTemplateArn(), other.recommendationTemplateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRecommendationTemplateRequest").add("ClientToken", clientToken())
                .add("RecommendationTemplateArn", recommendationTemplateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "recommendationTemplateArn":
            return Optional.ofNullable(clazz.cast(recommendationTemplateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecommendationTemplateRequest, T> g) {
        return obj -> g.apply((DeleteRecommendationTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRecommendationTemplateRequest> {
        /**
         * <p>
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         * characters. You should not reuse the same client token for other API requests.
         * </p>
         * 
         * @param clientToken
         *        Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         *        characters. You should not reuse the same client token for other API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a recommendation template.
         * </p>
         * 
         * @param recommendationTemplateArn
         *        The Amazon Resource Name (ARN) for a recommendation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTemplateArn(String recommendationTemplateArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String recommendationTemplateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecommendationTemplateRequest model) {
            super(model);
            clientToken(model.clientToken);
            recommendationTemplateArn(model.recommendationTemplateArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getRecommendationTemplateArn() {
            return recommendationTemplateArn;
        }

        public final void setRecommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
        }

        @Override
        @Transient
        public final Builder recommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRecommendationTemplateRequest build() {
            return new DeleteRecommendationTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
