/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ComponentRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.ComponentRecommendationListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppComponentRecommendationsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppComponentRecommendationsResponse> {
    private static final SdkField<List<ComponentRecommendation>> COMPONENT_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentRecommendations").getter(ListAppComponentRecommendationsResponse.getter(ListAppComponentRecommendationsResponse::componentRecommendations)).setter(ListAppComponentRecommendationsResponse.setter(Builder::componentRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppComponentRecommendationsResponse.getter(ListAppComponentRecommendationsResponse::nextToken)).setter(ListAppComponentRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_RECOMMENDATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ComponentRecommendation> componentRecommendations;
    private final String nextToken;

    private ListAppComponentRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.componentRecommendations = builder.componentRecommendations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComponentRecommendations() {
        return this.componentRecommendations != null && !(this.componentRecommendations instanceof SdkAutoConstructList);
    }

    public final List<ComponentRecommendation> componentRecommendations() {
        return this.componentRecommendations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentRecommendations() ? this.componentRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppComponentRecommendationsResponse)) {
            return false;
        }
        ListAppComponentRecommendationsResponse other = (ListAppComponentRecommendationsResponse)((Object)obj);
        return this.hasComponentRecommendations() == other.hasComponentRecommendations() && Objects.equals(this.componentRecommendations(), other.componentRecommendations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppComponentRecommendationsResponse").add("ComponentRecommendations", this.hasComponentRecommendations() ? this.componentRecommendations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentRecommendations": {
                return Optional.ofNullable(clazz.cast(this.componentRecommendations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppComponentRecommendationsResponse, T> g) {
        return obj -> g.apply((ListAppComponentRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<ComponentRecommendation> componentRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppComponentRecommendationsResponse model) {
            super(model);
            this.componentRecommendations(model.componentRecommendations);
            this.nextToken(model.nextToken);
        }

        public final List<ComponentRecommendation.Builder> getComponentRecommendations() {
            List<ComponentRecommendation.Builder> result = ComponentRecommendationListCopier.copyToBuilder(this.componentRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentRecommendations(Collection<ComponentRecommendation.BuilderImpl> componentRecommendations) {
            this.componentRecommendations = ComponentRecommendationListCopier.copyFromBuilder(componentRecommendations);
        }

        @Override
        @Transient
        public final Builder componentRecommendations(Collection<ComponentRecommendation> componentRecommendations) {
            this.componentRecommendations = ComponentRecommendationListCopier.copy(componentRecommendations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder componentRecommendations(ComponentRecommendation ... componentRecommendations) {
            this.componentRecommendations(Arrays.asList(componentRecommendations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder componentRecommendations(Consumer<ComponentRecommendation.Builder> ... componentRecommendations) {
            this.componentRecommendations(Stream.of(componentRecommendations).map(c -> (ComponentRecommendation)((ComponentRecommendation.Builder)ComponentRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppComponentRecommendationsResponse build() {
            return new ListAppComponentRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppComponentRecommendationsResponse> {
        public Builder componentRecommendations(Collection<ComponentRecommendation> var1);

        public Builder componentRecommendations(ComponentRecommendation ... var1);

        public Builder componentRecommendations(Consumer<ComponentRecommendation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

