/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationIdListCopier;
import software.amazon.awssdk.services.resiliencehub.model.RecommendationTemplateStatus;
import software.amazon.awssdk.services.resiliencehub.model.RenderRecommendationType;
import software.amazon.awssdk.services.resiliencehub.model.RenderRecommendationTypeListCopier;
import software.amazon.awssdk.services.resiliencehub.model.S3Location;
import software.amazon.awssdk.services.resiliencehub.model.TagMapCopier;
import software.amazon.awssdk.services.resiliencehub.model.TemplateFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationTemplate> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(RecommendationTemplate.getter(RecommendationTemplate::appArn)).setter(RecommendationTemplate.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentArn").getter(RecommendationTemplate.getter(RecommendationTemplate::assessmentArn)).setter(RecommendationTemplate.setter(Builder::assessmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(RecommendationTemplate.getter(RecommendationTemplate::endTime)).setter(RecommendationTemplate.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(RecommendationTemplate.getter(RecommendationTemplate::formatAsString)).setter(RecommendationTemplate.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(RecommendationTemplate.getter(RecommendationTemplate::message)).setter(RecommendationTemplate.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RecommendationTemplate.getter(RecommendationTemplate::name)).setter(RecommendationTemplate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Boolean> NEEDS_REPLACEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("needsReplacements").getter(RecommendationTemplate.getter(RecommendationTemplate::needsReplacements)).setter(RecommendationTemplate.setter(Builder::needsReplacements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("needsReplacements").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationIds").getter(RecommendationTemplate.getter(RecommendationTemplate::recommendationIds)).setter(RecommendationTemplate.setter(Builder::recommendationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationTemplateArn").getter(RecommendationTemplate.getter(RecommendationTemplate::recommendationTemplateArn)).setter(RecommendationTemplate.setter(Builder::recommendationTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTemplateArn").build()}).build();
    private static final SdkField<List<String>> RECOMMENDATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendationTypes").getter(RecommendationTemplate.getter(RecommendationTemplate::recommendationTypesAsStrings)).setter(RecommendationTemplate.setter(Builder::recommendationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(RecommendationTemplate.getter(RecommendationTemplate::startTime)).setter(RecommendationTemplate.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RecommendationTemplate.getter(RecommendationTemplate::statusAsString)).setter(RecommendationTemplate.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(RecommendationTemplate.getter(RecommendationTemplate::tags)).setter(RecommendationTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<S3Location> TEMPLATES_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templatesLocation").getter(RecommendationTemplate.getter(RecommendationTemplate::templatesLocation)).setter(RecommendationTemplate.setter(Builder::templatesLocation)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templatesLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, ASSESSMENT_ARN_FIELD, END_TIME_FIELD, FORMAT_FIELD, MESSAGE_FIELD, NAME_FIELD, NEEDS_REPLACEMENTS_FIELD, RECOMMENDATION_IDS_FIELD, RECOMMENDATION_TEMPLATE_ARN_FIELD, RECOMMENDATION_TYPES_FIELD, START_TIME_FIELD, STATUS_FIELD, TAGS_FIELD, TEMPLATES_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appArn;
    private final String assessmentArn;
    private final Instant endTime;
    private final String format;
    private final String message;
    private final String name;
    private final Boolean needsReplacements;
    private final List<String> recommendationIds;
    private final String recommendationTemplateArn;
    private final List<String> recommendationTypes;
    private final Instant startTime;
    private final String status;
    private final Map<String, String> tags;
    private final S3Location templatesLocation;

    private RecommendationTemplate(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.assessmentArn = builder.assessmentArn;
        this.endTime = builder.endTime;
        this.format = builder.format;
        this.message = builder.message;
        this.name = builder.name;
        this.needsReplacements = builder.needsReplacements;
        this.recommendationIds = builder.recommendationIds;
        this.recommendationTemplateArn = builder.recommendationTemplateArn;
        this.recommendationTypes = builder.recommendationTypes;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.tags = builder.tags;
        this.templatesLocation = builder.templatesLocation;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String assessmentArn() {
        return this.assessmentArn;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final TemplateFormat format() {
        return TemplateFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String message() {
        return this.message;
    }

    public final String name() {
        return this.name;
    }

    public final Boolean needsReplacements() {
        return this.needsReplacements;
    }

    public final boolean hasRecommendationIds() {
        return this.recommendationIds != null && !(this.recommendationIds instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationIds() {
        return this.recommendationIds;
    }

    public final String recommendationTemplateArn() {
        return this.recommendationTemplateArn;
    }

    public final List<RenderRecommendationType> recommendationTypes() {
        return RenderRecommendationTypeListCopier.copyStringToEnum(this.recommendationTypes);
    }

    public final boolean hasRecommendationTypes() {
        return this.recommendationTypes != null && !(this.recommendationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> recommendationTypesAsStrings() {
        return this.recommendationTypes;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final RecommendationTemplateStatus status() {
        return RecommendationTemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final S3Location templatesLocation() {
        return this.templatesLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.needsReplacements());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationIds() ? this.recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationTypes() ? this.recommendationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.templatesLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationTemplate)) {
            return false;
        }
        RecommendationTemplate other = (RecommendationTemplate)obj;
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.assessmentArn(), other.assessmentArn()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.needsReplacements(), other.needsReplacements()) && this.hasRecommendationIds() == other.hasRecommendationIds() && Objects.equals(this.recommendationIds(), other.recommendationIds()) && Objects.equals(this.recommendationTemplateArn(), other.recommendationTemplateArn()) && this.hasRecommendationTypes() == other.hasRecommendationTypes() && Objects.equals(this.recommendationTypesAsStrings(), other.recommendationTypesAsStrings()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.templatesLocation(), other.templatesLocation());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationTemplate").add("AppArn", (Object)this.appArn()).add("AssessmentArn", (Object)this.assessmentArn()).add("EndTime", (Object)this.endTime()).add("Format", (Object)this.formatAsString()).add("Message", (Object)this.message()).add("Name", (Object)this.name()).add("NeedsReplacements", (Object)this.needsReplacements()).add("RecommendationIds", this.hasRecommendationIds() ? this.recommendationIds() : null).add("RecommendationTemplateArn", (Object)this.recommendationTemplateArn()).add("RecommendationTypes", this.hasRecommendationTypes() ? this.recommendationTypesAsStrings() : null).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("TemplatesLocation", (Object)this.templatesLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "assessmentArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentArn()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "needsReplacements": {
                return Optional.ofNullable(clazz.cast(this.needsReplacements()));
            }
            case "recommendationIds": {
                return Optional.ofNullable(clazz.cast(this.recommendationIds()));
            }
            case "recommendationTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.recommendationTemplateArn()));
            }
            case "recommendationTypes": {
                return Optional.ofNullable(clazz.cast(this.recommendationTypesAsStrings()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "templatesLocation": {
                return Optional.ofNullable(clazz.cast(this.templatesLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationTemplate, T> g) {
        return obj -> g.apply((RecommendationTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appArn;
        private String assessmentArn;
        private Instant endTime;
        private String format;
        private String message;
        private String name;
        private Boolean needsReplacements;
        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();
        private String recommendationTemplateArn;
        private List<String> recommendationTypes = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private S3Location templatesLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationTemplate model) {
            this.appArn(model.appArn);
            this.assessmentArn(model.assessmentArn);
            this.endTime(model.endTime);
            this.format(model.format);
            this.message(model.message);
            this.name(model.name);
            this.needsReplacements(model.needsReplacements);
            this.recommendationIds(model.recommendationIds);
            this.recommendationTemplateArn(model.recommendationTemplateArn);
            this.recommendationTypesWithStrings(model.recommendationTypes);
            this.startTime(model.startTime);
            this.status(model.status);
            this.tags(model.tags);
            this.templatesLocation(model.templatesLocation);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        @Transient
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentArn() {
            return this.assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        @Transient
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(TemplateFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getNeedsReplacements() {
            return this.needsReplacements;
        }

        public final void setNeedsReplacements(Boolean needsReplacements) {
            this.needsReplacements = needsReplacements;
        }

        @Override
        @Transient
        public final Builder needsReplacements(Boolean needsReplacements) {
            this.needsReplacements = needsReplacements;
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (this.recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        @Transient
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendationIds(String ... recommendationIds) {
            this.recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final String getRecommendationTemplateArn() {
            return this.recommendationTemplateArn;
        }

        public final void setRecommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
        }

        @Override
        @Transient
        public final Builder recommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
            return this;
        }

        public final Collection<String> getRecommendationTypes() {
            if (this.recommendationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recommendationTypes;
        }

        public final void setRecommendationTypes(Collection<String> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copy(recommendationTypes);
        }

        @Override
        @Transient
        public final Builder recommendationTypesWithStrings(Collection<String> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copy(recommendationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendationTypesWithStrings(String ... recommendationTypes) {
            this.recommendationTypesWithStrings(Arrays.asList(recommendationTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder recommendationTypes(Collection<RenderRecommendationType> recommendationTypes) {
            this.recommendationTypes = RenderRecommendationTypeListCopier.copyEnumToString(recommendationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendationTypes(RenderRecommendationType ... recommendationTypes) {
            this.recommendationTypes(Arrays.asList(recommendationTypes));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RecommendationTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final S3Location.Builder getTemplatesLocation() {
            return this.templatesLocation != null ? this.templatesLocation.toBuilder() : null;
        }

        public final void setTemplatesLocation(S3Location.BuilderImpl templatesLocation) {
            this.templatesLocation = templatesLocation != null ? templatesLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder templatesLocation(S3Location templatesLocation) {
            this.templatesLocation = templatesLocation;
            return this;
        }

        public RecommendationTemplate build() {
            return new RecommendationTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationTemplate> {
        public Builder appArn(String var1);

        public Builder assessmentArn(String var1);

        public Builder endTime(Instant var1);

        public Builder format(String var1);

        public Builder format(TemplateFormat var1);

        public Builder message(String var1);

        public Builder name(String var1);

        public Builder needsReplacements(Boolean var1);

        public Builder recommendationIds(Collection<String> var1);

        public Builder recommendationIds(String ... var1);

        public Builder recommendationTemplateArn(String var1);

        public Builder recommendationTypesWithStrings(Collection<String> var1);

        public Builder recommendationTypesWithStrings(String ... var1);

        public Builder recommendationTypes(Collection<RenderRecommendationType> var1);

        public Builder recommendationTypes(RenderRecommendationType ... var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(RecommendationTemplateStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder templatesLocation(S3Location var1);

        default public Builder templatesLocation(Consumer<S3Location.Builder> templatesLocation) {
            return this.templatesLocation((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(templatesLocation)).build());
        }
    }
}

