/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteRecommendationTemplateResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<DeleteRecommendationTemplateResponse.Builder, DeleteRecommendationTemplateResponse> {
    private static final SdkField<String> RECOMMENDATION_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationTemplateArn")
            .getter(getter(DeleteRecommendationTemplateResponse::recommendationTemplateArn))
            .setter(setter(Builder::recommendationTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationTemplateArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeleteRecommendationTemplateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RECOMMENDATION_TEMPLATE_ARN_FIELD, STATUS_FIELD));

    private final String recommendationTemplateArn;

    private final String status;

    private DeleteRecommendationTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationTemplateArn = builder.recommendationTemplateArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a recommendation template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a recommendation template.
     */
    public final String recommendationTemplateArn() {
        return recommendationTemplateArn;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see RecommendationTemplateStatus
     */
    public final RecommendationTemplateStatus status() {
        return RecommendationTemplateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationTemplateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see RecommendationTemplateStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRecommendationTemplateResponse)) {
            return false;
        }
        DeleteRecommendationTemplateResponse other = (DeleteRecommendationTemplateResponse) obj;
        return Objects.equals(recommendationTemplateArn(), other.recommendationTemplateArn())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteRecommendationTemplateResponse")
                .add("RecommendationTemplateArn", recommendationTemplateArn()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendationTemplateArn":
            return Optional.ofNullable(clazz.cast(recommendationTemplateArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRecommendationTemplateResponse, T> g) {
        return obj -> g.apply((DeleteRecommendationTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteRecommendationTemplateResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a recommendation template.
         * </p>
         * 
         * @param recommendationTemplateArn
         *        The Amazon Resource Name (ARN) for a recommendation template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationTemplateArn(String recommendationTemplateArn);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see RecommendationTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationTemplateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see RecommendationTemplateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationTemplateStatus
         */
        Builder status(RecommendationTemplateStatus status);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String recommendationTemplateArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRecommendationTemplateResponse model) {
            super(model);
            recommendationTemplateArn(model.recommendationTemplateArn);
            status(model.status);
        }

        public final String getRecommendationTemplateArn() {
            return recommendationTemplateArn;
        }

        public final void setRecommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
        }

        @Override
        @Transient
        public final Builder recommendationTemplateArn(String recommendationTemplateArn) {
            this.recommendationTemplateArn = recommendationTemplateArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(RecommendationTemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeleteRecommendationTemplateResponse build() {
            return new DeleteRecommendationTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
