/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppVersionsResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListAppVersionsResponse.Builder, ListAppVersionsResponse> {
    private static final SdkField<List<AppVersionSummary>> APP_VERSIONS_FIELD = SdkField
            .<List<AppVersionSummary>> builder(MarshallingType.LIST)
            .memberName("appVersions")
            .getter(getter(ListAppVersionsResponse::appVersions))
            .setter(setter(Builder::appVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppVersionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_VERSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AppVersionSummary> appVersions;

    private final String nextToken;

    private ListAppVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.appVersions = builder.appVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppVersions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppVersions() {
        return appVersions != null && !(appVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppVersions} method.
     * </p>
     * 
     * @return The version of the application.
     */
    public final List<AppVersionSummary> appVersions() {
        return appVersions;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAppVersions() ? appVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionsResponse)) {
            return false;
        }
        ListAppVersionsResponse other = (ListAppVersionsResponse) obj;
        return hasAppVersions() == other.hasAppVersions() && Objects.equals(appVersions(), other.appVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppVersionsResponse").add("AppVersions", hasAppVersions() ? appVersions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appVersions":
            return Optional.ofNullable(clazz.cast(appVersions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionsResponse, T> g) {
        return obj -> g.apply((ListAppVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppVersionsResponse> {
        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param appVersions
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersions(Collection<AppVersionSummary> appVersions);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param appVersions
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersions(AppVersionSummary... appVersions);

        /**
         * <p>
         * The version of the application.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppVersionSummary>.Builder} avoiding the
         * need to create one manually via {@link List<AppVersionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppVersionSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #appVersions(List<AppVersionSummary>)}.
         * 
         * @param appVersions
         *        a consumer that will call methods on {@link List<AppVersionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appVersions(List<AppVersionSummary>)
         */
        Builder appVersions(Consumer<AppVersionSummary.Builder>... appVersions);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private List<AppVersionSummary> appVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionsResponse model) {
            super(model);
            appVersions(model.appVersions);
            nextToken(model.nextToken);
        }

        public final List<AppVersionSummary.Builder> getAppVersions() {
            List<AppVersionSummary.Builder> result = AppVersionListCopier.copyToBuilder(this.appVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppVersions(Collection<AppVersionSummary.BuilderImpl> appVersions) {
            this.appVersions = AppVersionListCopier.copyFromBuilder(appVersions);
        }

        @Override
        @Transient
        public final Builder appVersions(Collection<AppVersionSummary> appVersions) {
            this.appVersions = AppVersionListCopier.copy(appVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appVersions(AppVersionSummary... appVersions) {
            appVersions(Arrays.asList(appVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder appVersions(Consumer<AppVersionSummary.Builder>... appVersions) {
            appVersions(Stream.of(appVersions).map(c -> AppVersionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppVersionsResponse build() {
            return new ListAppVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
