/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSuggestedResiliencyPoliciesResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListSuggestedResiliencyPoliciesResponse.Builder, ListSuggestedResiliencyPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSuggestedResiliencyPoliciesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ResiliencyPolicy>> RESILIENCY_POLICIES_FIELD = SdkField
            .<List<ResiliencyPolicy>> builder(MarshallingType.LIST)
            .memberName("resiliencyPolicies")
            .getter(getter(ListSuggestedResiliencyPoliciesResponse::resiliencyPolicies))
            .setter(setter(Builder::resiliencyPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResiliencyPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResiliencyPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESILIENCY_POLICIES_FIELD));

    private final String nextToken;

    private final List<ResiliencyPolicy> resiliencyPolicies;

    private ListSuggestedResiliencyPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resiliencyPolicies = builder.resiliencyPolicies;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResiliencyPolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResiliencyPolicies() {
        return resiliencyPolicies != null && !(resiliencyPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The suggested resiliency policies for the Resilience Hub applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResiliencyPolicies} method.
     * </p>
     * 
     * @return The suggested resiliency policies for the Resilience Hub applications.
     */
    public final List<ResiliencyPolicy> resiliencyPolicies() {
        return resiliencyPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResiliencyPolicies() ? resiliencyPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuggestedResiliencyPoliciesResponse)) {
            return false;
        }
        ListSuggestedResiliencyPoliciesResponse other = (ListSuggestedResiliencyPoliciesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasResiliencyPolicies() == other.hasResiliencyPolicies()
                && Objects.equals(resiliencyPolicies(), other.resiliencyPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSuggestedResiliencyPoliciesResponse").add("NextToken", nextToken())
                .add("ResiliencyPolicies", hasResiliencyPolicies() ? resiliencyPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resiliencyPolicies":
            return Optional.ofNullable(clazz.cast(resiliencyPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSuggestedResiliencyPoliciesResponse, T> g) {
        return obj -> g.apply((ListSuggestedResiliencyPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSuggestedResiliencyPoliciesResponse> {
        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The suggested resiliency policies for the Resilience Hub applications.
         * </p>
         * 
         * @param resiliencyPolicies
         *        The suggested resiliency policies for the Resilience Hub applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resiliencyPolicies(Collection<ResiliencyPolicy> resiliencyPolicies);

        /**
         * <p>
         * The suggested resiliency policies for the Resilience Hub applications.
         * </p>
         * 
         * @param resiliencyPolicies
         *        The suggested resiliency policies for the Resilience Hub applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resiliencyPolicies(ResiliencyPolicy... resiliencyPolicies);

        /**
         * <p>
         * The suggested resiliency policies for the Resilience Hub applications.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResiliencyPolicy>.Builder} avoiding the
         * need to create one manually via {@link List<ResiliencyPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResiliencyPolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #resiliencyPolicies(List<ResiliencyPolicy>)}.
         * 
         * @param resiliencyPolicies
         *        a consumer that will call methods on {@link List<ResiliencyPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resiliencyPolicies(List<ResiliencyPolicy>)
         */
        Builder resiliencyPolicies(Consumer<ResiliencyPolicy.Builder>... resiliencyPolicies);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResiliencyPolicy> resiliencyPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuggestedResiliencyPoliciesResponse model) {
            super(model);
            nextToken(model.nextToken);
            resiliencyPolicies(model.resiliencyPolicies);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResiliencyPolicy.Builder> getResiliencyPolicies() {
            List<ResiliencyPolicy.Builder> result = ResiliencyPoliciesCopier.copyToBuilder(this.resiliencyPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResiliencyPolicies(Collection<ResiliencyPolicy.BuilderImpl> resiliencyPolicies) {
            this.resiliencyPolicies = ResiliencyPoliciesCopier.copyFromBuilder(resiliencyPolicies);
        }

        @Override
        @Transient
        public final Builder resiliencyPolicies(Collection<ResiliencyPolicy> resiliencyPolicies) {
            this.resiliencyPolicies = ResiliencyPoliciesCopier.copy(resiliencyPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resiliencyPolicies(ResiliencyPolicy... resiliencyPolicies) {
            resiliencyPolicies(Arrays.asList(resiliencyPolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resiliencyPolicies(Consumer<ResiliencyPolicy.Builder>... resiliencyPolicies) {
            resiliencyPolicies(Stream.of(resiliencyPolicies).map(c -> ResiliencyPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSuggestedResiliencyPoliciesResponse build() {
            return new ListSuggestedResiliencyPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
