/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentInvoker;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentStatus;
import software.amazon.awssdk.services.resiliencehub.model.ComplianceStatus;
import software.amazon.awssdk.services.resiliencehub.model.Cost;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppAssessmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppAssessmentSummary> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(AppAssessmentSummary.getter(AppAssessmentSummary::appArn)).setter(AppAssessmentSummary.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(AppAssessmentSummary.getter(AppAssessmentSummary::appVersion)).setter(AppAssessmentSummary.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentArn").getter(AppAssessmentSummary.getter(AppAssessmentSummary::assessmentArn)).setter(AppAssessmentSummary.setter(Builder::assessmentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()}).build();
    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentName").getter(AppAssessmentSummary.getter(AppAssessmentSummary::assessmentName)).setter(AppAssessmentSummary.setter(Builder::assessmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()}).build();
    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assessmentStatus").getter(AppAssessmentSummary.getter(AppAssessmentSummary::assessmentStatusAsString)).setter(AppAssessmentSummary.setter(Builder::assessmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentStatus").build()}).build();
    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("complianceStatus").getter(AppAssessmentSummary.getter(AppAssessmentSummary::complianceStatusAsString)).setter(AppAssessmentSummary.setter(Builder::complianceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()}).build();
    private static final SdkField<Cost> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cost").getter(AppAssessmentSummary.getter(AppAssessmentSummary::cost)).setter(AppAssessmentSummary.setter(Builder::cost)).constructor(Cost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AppAssessmentSummary.getter(AppAssessmentSummary::endTime)).setter(AppAssessmentSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> INVOKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invoker").getter(AppAssessmentSummary.getter(AppAssessmentSummary::invokerAsString)).setter(AppAssessmentSummary.setter(Builder::invoker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invoker").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AppAssessmentSummary.getter(AppAssessmentSummary::message)).setter(AppAssessmentSummary.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Double> RESILIENCY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("resiliencyScore").getter(AppAssessmentSummary.getter(AppAssessmentSummary::resiliencyScore)).setter(AppAssessmentSummary.setter(Builder::resiliencyScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AppAssessmentSummary.getter(AppAssessmentSummary::startTime)).setter(AppAssessmentSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, ASSESSMENT_ARN_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_STATUS_FIELD, COMPLIANCE_STATUS_FIELD, COST_FIELD, END_TIME_FIELD, INVOKER_FIELD, MESSAGE_FIELD, RESILIENCY_SCORE_FIELD, START_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String appArn;
    private final String appVersion;
    private final String assessmentArn;
    private final String assessmentName;
    private final String assessmentStatus;
    private final String complianceStatus;
    private final Cost cost;
    private final Instant endTime;
    private final String invoker;
    private final String message;
    private final Double resiliencyScore;
    private final Instant startTime;

    private AppAssessmentSummary(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.assessmentArn = builder.assessmentArn;
        this.assessmentName = builder.assessmentName;
        this.assessmentStatus = builder.assessmentStatus;
        this.complianceStatus = builder.complianceStatus;
        this.cost = builder.cost;
        this.endTime = builder.endTime;
        this.invoker = builder.invoker;
        this.message = builder.message;
        this.resiliencyScore = builder.resiliencyScore;
        this.startTime = builder.startTime;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final String assessmentArn() {
        return this.assessmentArn;
    }

    public final String assessmentName() {
        return this.assessmentName;
    }

    public final AssessmentStatus assessmentStatus() {
        return AssessmentStatus.fromValue(this.assessmentStatus);
    }

    public final String assessmentStatusAsString() {
        return this.assessmentStatus;
    }

    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(this.complianceStatus);
    }

    public final String complianceStatusAsString() {
        return this.complianceStatus;
    }

    public final Cost cost() {
        return this.cost;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final AssessmentInvoker invoker() {
        return AssessmentInvoker.fromValue(this.invoker);
    }

    public final String invokerAsString() {
        return this.invoker;
    }

    public final String message() {
        return this.message;
    }

    public final Double resiliencyScore() {
        return this.resiliencyScore;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppAssessmentSummary)) {
            return false;
        }
        AppAssessmentSummary other = (AppAssessmentSummary)obj;
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.assessmentArn(), other.assessmentArn()) && Objects.equals(this.assessmentName(), other.assessmentName()) && Objects.equals(this.assessmentStatusAsString(), other.assessmentStatusAsString()) && Objects.equals(this.complianceStatusAsString(), other.complianceStatusAsString()) && Objects.equals(this.cost(), other.cost()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.invokerAsString(), other.invokerAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.resiliencyScore(), other.resiliencyScore()) && Objects.equals(this.startTime(), other.startTime());
    }

    public final String toString() {
        return ToString.builder((String)"AppAssessmentSummary").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("AssessmentArn", (Object)this.assessmentArn()).add("AssessmentName", (Object)this.assessmentName()).add("AssessmentStatus", (Object)this.assessmentStatusAsString()).add("ComplianceStatus", (Object)this.complianceStatusAsString()).add("Cost", (Object)this.cost()).add("EndTime", (Object)this.endTime()).add("Invoker", (Object)this.invokerAsString()).add("Message", (Object)this.message()).add("ResiliencyScore", (Object)this.resiliencyScore()).add("StartTime", (Object)this.startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "assessmentArn": {
                return Optional.ofNullable(clazz.cast(this.assessmentArn()));
            }
            case "assessmentName": {
                return Optional.ofNullable(clazz.cast(this.assessmentName()));
            }
            case "assessmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assessmentStatusAsString()));
            }
            case "complianceStatus": {
                return Optional.ofNullable(clazz.cast(this.complianceStatusAsString()));
            }
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "invoker": {
                return Optional.ofNullable(clazz.cast(this.invokerAsString()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "resiliencyScore": {
                return Optional.ofNullable(clazz.cast(this.resiliencyScore()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppAssessmentSummary, T> g) {
        return obj -> g.apply((AppAssessmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private String assessmentArn;
        private String assessmentName;
        private String assessmentStatus;
        private String complianceStatus;
        private Cost cost;
        private Instant endTime;
        private String invoker;
        private String message;
        private Double resiliencyScore;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AppAssessmentSummary model) {
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.assessmentArn(model.assessmentArn);
            this.assessmentName(model.assessmentName);
            this.assessmentStatus(model.assessmentStatus);
            this.complianceStatus(model.complianceStatus);
            this.cost(model.cost);
            this.endTime(model.endTime);
            this.invoker(model.invoker);
            this.message(model.message);
            this.resiliencyScore(model.resiliencyScore);
            this.startTime(model.startTime);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        @Transient
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        @Transient
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getAssessmentArn() {
            return this.assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        @Transient
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getAssessmentName() {
            return this.assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        @Transient
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentStatus() {
            return this.assessmentStatus;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        @Override
        @Transient
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder assessmentStatus(AssessmentStatus assessmentStatus) {
            this.assessmentStatus(assessmentStatus == null ? null : assessmentStatus.toString());
            return this;
        }

        public final String getComplianceStatus() {
            return this.complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        @Transient
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Cost.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        @Transient
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        @Transient
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getInvoker() {
            return this.invoker;
        }

        public final void setInvoker(String invoker) {
            this.invoker = invoker;
        }

        @Override
        @Transient
        public final Builder invoker(String invoker) {
            this.invoker = invoker;
            return this;
        }

        @Override
        @Transient
        public final Builder invoker(AssessmentInvoker invoker) {
            this.invoker(invoker == null ? null : invoker.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Double getResiliencyScore() {
            return this.resiliencyScore;
        }

        public final void setResiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
        }

        @Override
        @Transient
        public final Builder resiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public AppAssessmentSummary build() {
            return new AppAssessmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppAssessmentSummary> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder assessmentArn(String var1);

        public Builder assessmentName(String var1);

        public Builder assessmentStatus(String var1);

        public Builder assessmentStatus(AssessmentStatus var1);

        public Builder complianceStatus(String var1);

        public Builder complianceStatus(ComplianceStatus var1);

        public Builder cost(Cost var1);

        default public Builder cost(Consumer<Cost.Builder> cost) {
            return this.cost((Cost)((Cost.Builder)Cost.builder().applyMutation(cost)).build());
        }

        public Builder endTime(Instant var1);

        public Builder invoker(String var1);

        public Builder invoker(AssessmentInvoker var1);

        public Builder message(String var1);

        public Builder resiliencyScore(Double var1);

        public Builder startTime(Instant var1);
    }
}

