/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppAssessmentSummary;
import software.amazon.awssdk.services.resiliencehub.model.AppAssessmentSummaryListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppAssessmentsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppAssessmentsResponse> {
    private static final SdkField<List<AppAssessmentSummary>> ASSESSMENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assessmentSummaries").getter(ListAppAssessmentsResponse.getter(ListAppAssessmentsResponse::assessmentSummaries)).setter(ListAppAssessmentsResponse.setter(Builder::assessmentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppAssessmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppAssessmentsResponse.getter(ListAppAssessmentsResponse::nextToken)).setter(ListAppAssessmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AppAssessmentSummary> assessmentSummaries;
    private final String nextToken;

    private ListAppAssessmentsResponse(BuilderImpl builder) {
        super(builder);
        this.assessmentSummaries = builder.assessmentSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAssessmentSummaries() {
        return this.assessmentSummaries != null && !(this.assessmentSummaries instanceof SdkAutoConstructList);
    }

    public final List<AppAssessmentSummary> assessmentSummaries() {
        return this.assessmentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentSummaries() ? this.assessmentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppAssessmentsResponse)) {
            return false;
        }
        ListAppAssessmentsResponse other = (ListAppAssessmentsResponse)((Object)obj);
        return this.hasAssessmentSummaries() == other.hasAssessmentSummaries() && Objects.equals(this.assessmentSummaries(), other.assessmentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppAssessmentsResponse").add("AssessmentSummaries", this.hasAssessmentSummaries() ? this.assessmentSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessmentSummaries": {
                return Optional.ofNullable(clazz.cast(this.assessmentSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppAssessmentsResponse, T> g) {
        return obj -> g.apply((ListAppAssessmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<AppAssessmentSummary> assessmentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppAssessmentsResponse model) {
            super(model);
            this.assessmentSummaries(model.assessmentSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<AppAssessmentSummary.Builder> getAssessmentSummaries() {
            List<AppAssessmentSummary.Builder> result = AppAssessmentSummaryListCopier.copyToBuilder(this.assessmentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentSummaries(Collection<AppAssessmentSummary.BuilderImpl> assessmentSummaries) {
            this.assessmentSummaries = AppAssessmentSummaryListCopier.copyFromBuilder(assessmentSummaries);
        }

        @Override
        @Transient
        public final Builder assessmentSummaries(Collection<AppAssessmentSummary> assessmentSummaries) {
            this.assessmentSummaries = AppAssessmentSummaryListCopier.copy(assessmentSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assessmentSummaries(AppAssessmentSummary ... assessmentSummaries) {
            this.assessmentSummaries(Arrays.asList(assessmentSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assessmentSummaries(Consumer<AppAssessmentSummary.Builder> ... assessmentSummaries) {
            this.assessmentSummaries(Stream.of(assessmentSummaries).map(c -> (AppAssessmentSummary)((AppAssessmentSummary.Builder)AppAssessmentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppAssessmentsResponse build() {
            return new ListAppAssessmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppAssessmentsResponse> {
        public Builder assessmentSummaries(Collection<AppAssessmentSummary> var1);

        public Builder assessmentSummaries(AppAssessmentSummary ... var1);

        public Builder assessmentSummaries(Consumer<AppAssessmentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

