/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogicalResourceId
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogicalResourceId> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(LogicalResourceId.getter(LogicalResourceId::identifier)).setter(LogicalResourceId.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> LOGICAL_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logicalStackName").getter(LogicalResourceId.getter(LogicalResourceId::logicalStackName)).setter(LogicalResourceId.setter(Builder::logicalStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackName").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGroupName").getter(LogicalResourceId.getter(LogicalResourceId::resourceGroupName)).setter(LogicalResourceId.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, LOGICAL_STACK_NAME_FIELD, RESOURCE_GROUP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String logicalStackName;
    private final String resourceGroupName;

    private LogicalResourceId(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.logicalStackName = builder.logicalStackName;
        this.resourceGroupName = builder.resourceGroupName;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String logicalStackName() {
        return this.logicalStackName;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalResourceId)) {
            return false;
        }
        LogicalResourceId other = (LogicalResourceId)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.logicalStackName(), other.logicalStackName()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"LogicalResourceId").add("Identifier", (Object)this.identifier()).add("LogicalStackName", (Object)this.logicalStackName()).add("ResourceGroupName", (Object)this.resourceGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "logicalStackName": {
                return Optional.ofNullable(clazz.cast(this.logicalStackName()));
            }
            case "resourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogicalResourceId, T> g) {
        return obj -> g.apply((LogicalResourceId)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String logicalStackName;
        private String resourceGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalResourceId model) {
            this.identifier(model.identifier);
            this.logicalStackName(model.logicalStackName);
            this.resourceGroupName(model.resourceGroupName);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        @Transient
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getLogicalStackName() {
            return this.logicalStackName;
        }

        public final void setLogicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
        }

        @Override
        @Transient
        public final Builder logicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
            return this;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        @Transient
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public LogicalResourceId build() {
            return new LogicalResourceId(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogicalResourceId> {
        public Builder identifier(String var1);

        public Builder logicalStackName(String var1);

        public Builder resourceGroupName(String var1);
    }
}

