/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddDraftAppVersionResourceMappingsResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<AddDraftAppVersionResourceMappingsResponse.Builder, AddDraftAppVersionResourceMappingsResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(AddDraftAppVersionResourceMappingsResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(AddDraftAppVersionResourceMappingsResponse::appVersion))
            .setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<List<ResourceMapping>> RESOURCE_MAPPINGS_FIELD = SdkField
            .<List<ResourceMapping>> builder(MarshallingType.LIST)
            .memberName("resourceMappings")
            .getter(getter(AddDraftAppVersionResourceMappingsResponse::resourceMappings))
            .setter(setter(Builder::resourceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, RESOURCE_MAPPINGS_FIELD));

    private final String appArn;

    private final String appVersion;

    private final List<ResourceMapping> resourceMappings;

    private AddDraftAppVersionResourceMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.resourceMappings = builder.resourceMappings;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information
     *         about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     *         Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceMappings() {
        return resourceMappings != null && !(resourceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Mappings used to map logical resources from the template to physical resources. You can use the mapping type
     * <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual resources
     * by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type <code>CFN_STACK</code> if
     * the application is backed by a CloudFormation stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceMappings} method.
     * </p>
     * 
     * @return Mappings used to map logical resources from the template to physical resources. You can use the mapping
     *         type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map
     *         individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type
     *         <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.
     */
    public final List<ResourceMapping> resourceMappings() {
        return resourceMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceMappings() ? resourceMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddDraftAppVersionResourceMappingsResponse)) {
            return false;
        }
        AddDraftAppVersionResourceMappingsResponse other = (AddDraftAppVersionResourceMappingsResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && hasResourceMappings() == other.hasResourceMappings()
                && Objects.equals(resourceMappings(), other.resourceMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddDraftAppVersionResourceMappingsResponse").add("AppArn", appArn())
                .add("AppVersion", appVersion()).add("ResourceMappings", hasResourceMappings() ? resourceMappings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "resourceMappings":
            return Optional.ofNullable(clazz.cast(resourceMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddDraftAppVersionResourceMappingsResponse, T> g) {
        return obj -> g.apply((AddDraftAppVersionResourceMappingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AddDraftAppVersionResourceMappingsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about
         * ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param appVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * Mappings used to map logical resources from the template to physical resources. You can use the mapping type
         * <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual
         * resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type
         * <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.
         * </p>
         * 
         * @param resourceMappings
         *        Mappings used to map logical resources from the template to physical resources. You can use the
         *        mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can
         *        map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the
         *        mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceMappings(Collection<ResourceMapping> resourceMappings);

        /**
         * <p>
         * Mappings used to map logical resources from the template to physical resources. You can use the mapping type
         * <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual
         * resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type
         * <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.
         * </p>
         * 
         * @param resourceMappings
         *        Mappings used to map logical resources from the template to physical resources. You can use the
         *        mapping type <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can
         *        map individual resources by using the mapping type <code>RESOURCE</code>. We recommend using the
         *        mapping type <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceMappings(ResourceMapping... resourceMappings);

        /**
         * <p>
         * Mappings used to map logical resources from the template to physical resources. You can use the mapping type
         * <code>CFN_STACK</code> if the application template uses a logical stack name. Or you can map individual
         * resources by using the mapping type <code>RESOURCE</code>. We recommend using the mapping type
         * <code>CFN_STACK</code> if the application is backed by a CloudFormation stack.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.ResourceMapping.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.resiliencehub.model.ResourceMapping#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.ResourceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceMappings(List<ResourceMapping>)}.
         * 
         * @param resourceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.ResourceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceMappings(java.util.Collection<ResourceMapping>)
         */
        Builder resourceMappings(Consumer<ResourceMapping.Builder>... resourceMappings);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private List<ResourceMapping> resourceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddDraftAppVersionResourceMappingsResponse model) {
            super(model);
            appArn(model.appArn);
            appVersion(model.appVersion);
            resourceMappings(model.resourceMappings);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<ResourceMapping.Builder> getResourceMappings() {
            List<ResourceMapping.Builder> result = ResourceMappingListCopier.copyToBuilder(this.resourceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceMappings(Collection<ResourceMapping.BuilderImpl> resourceMappings) {
            this.resourceMappings = ResourceMappingListCopier.copyFromBuilder(resourceMappings);
        }

        @Override
        public final Builder resourceMappings(Collection<ResourceMapping> resourceMappings) {
            this.resourceMappings = ResourceMappingListCopier.copy(resourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(ResourceMapping... resourceMappings) {
            resourceMappings(Arrays.asList(resourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(Consumer<ResourceMapping.Builder>... resourceMappings) {
            resourceMappings(Stream.of(resourceMappings).map(c -> ResourceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddDraftAppVersionResourceMappingsResponse build() {
            return new AddDraftAppVersionResourceMappingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
