/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportResourcesToDraftAppVersionResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ImportResourcesToDraftAppVersionResponse.Builder, ImportResourcesToDraftAppVersionResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(ImportResourcesToDraftAppVersionResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(ImportResourcesToDraftAppVersionResponse::appVersion))
            .setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<List<String>> SOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sourceArns")
            .getter(getter(ImportResourcesToDraftAppVersionResponse::sourceArns))
            .setter(setter(Builder::sourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImportResourcesToDraftAppVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<TerraformSource>> TERRAFORM_SOURCES_FIELD = SdkField
            .<List<TerraformSource>> builder(MarshallingType.LIST)
            .memberName("terraformSources")
            .getter(getter(ImportResourcesToDraftAppVersionResponse::terraformSources))
            .setter(setter(Builder::terraformSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TerraformSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(TerraformSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, SOURCE_ARNS_FIELD, STATUS_FIELD, TERRAFORM_SOURCES_FIELD));

    private final String appArn;

    private final String appVersion;

    private final List<String> sourceArns;

    private final String status;

    private final List<TerraformSource> terraformSources;

    private ImportResourcesToDraftAppVersionResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.sourceArns = builder.sourceArns;
        this.status = builder.status;
        this.terraformSources = builder.terraformSources;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about ARNs,
     * see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information
     *         about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     *         Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceArns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSourceArns() {
        return sourceArns != null && !(sourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) for the resources that you imported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) for the resources that you imported.
     */
    public final List<String> sourceArns() {
        return sourceArns;
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceImportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ResourceImportStatusType
     */
    public final ResourceImportStatusType status() {
        return ResourceImportStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceImportStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the action.
     * @see ResourceImportStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerraformSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerraformSources() {
        return terraformSources != null && !(terraformSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of terraform file s3 URLs you need to import.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerraformSources} method.
     * </p>
     * 
     * @return A list of terraform file s3 URLs you need to import.
     */
    public final List<TerraformSource> terraformSources() {
        return terraformSources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceArns() ? sourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTerraformSources() ? terraformSources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourcesToDraftAppVersionResponse)) {
            return false;
        }
        ImportResourcesToDraftAppVersionResponse other = (ImportResourcesToDraftAppVersionResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && hasSourceArns() == other.hasSourceArns() && Objects.equals(sourceArns(), other.sourceArns())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasTerraformSources() == other.hasTerraformSources()
                && Objects.equals(terraformSources(), other.terraformSources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportResourcesToDraftAppVersionResponse").add("AppArn", appArn())
                .add("AppVersion", appVersion()).add("SourceArns", hasSourceArns() ? sourceArns() : null)
                .add("Status", statusAsString()).add("TerraformSources", hasTerraformSources() ? terraformSources() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "sourceArns":
            return Optional.ofNullable(clazz.cast(sourceArns()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "terraformSources":
            return Optional.ofNullable(clazz.cast(terraformSources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportResourcesToDraftAppVersionResponse, T> g) {
        return obj -> g.apply((ImportResourcesToDraftAppVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ImportResourcesToDraftAppVersionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more information about
         * ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
         * Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param appVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the resources that you imported.
         * </p>
         * 
         * @param sourceArns
         *        The Amazon Resource Names (ARNs) for the resources that you imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArns(Collection<String> sourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) for the resources that you imported.
         * </p>
         * 
         * @param sourceArns
         *        The Amazon Resource Names (ARNs) for the resources that you imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArns(String... sourceArns);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ResourceImportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceImportStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the action.
         * </p>
         * 
         * @param status
         *        The status of the action.
         * @see ResourceImportStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceImportStatusType
         */
        Builder status(ResourceImportStatusType status);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * 
         * @param terraformSources
         *        A list of terraform file s3 URLs you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSources(Collection<TerraformSource> terraformSources);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * 
         * @param terraformSources
         *        A list of terraform file s3 URLs you need to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSources(TerraformSource... terraformSources);

        /**
         * <p>
         * A list of terraform file s3 URLs you need to import.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource.Builder#build()} is called
         * immediately and its result is passed to {@link #terraformSources(List<TerraformSource>)}.
         * 
         * @param terraformSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.TerraformSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terraformSources(java.util.Collection<TerraformSource>)
         */
        Builder terraformSources(Consumer<TerraformSource.Builder>... terraformSources);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private List<String> sourceArns = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private List<TerraformSource> terraformSources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourcesToDraftAppVersionResponse model) {
            super(model);
            appArn(model.appArn);
            appVersion(model.appVersion);
            sourceArns(model.sourceArns);
            status(model.status);
            terraformSources(model.terraformSources);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final Collection<String> getSourceArns() {
            if (sourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceArns;
        }

        public final void setSourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
        }

        @Override
        public final Builder sourceArns(Collection<String> sourceArns) {
            this.sourceArns = ArnListCopier.copy(sourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceArns(String... sourceArns) {
            sourceArns(Arrays.asList(sourceArns));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceImportStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<TerraformSource.Builder> getTerraformSources() {
            List<TerraformSource.Builder> result = TerraformSourceListCopier.copyToBuilder(this.terraformSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerraformSources(Collection<TerraformSource.BuilderImpl> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copyFromBuilder(terraformSources);
        }

        @Override
        public final Builder terraformSources(Collection<TerraformSource> terraformSources) {
            this.terraformSources = TerraformSourceListCopier.copy(terraformSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(TerraformSource... terraformSources) {
            terraformSources(Arrays.asList(terraformSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terraformSources(Consumer<TerraformSource.Builder>... terraformSources) {
            terraformSources(Stream.of(terraformSources).map(c -> TerraformSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ImportResourcesToDraftAppVersionResponse build() {
            return new ImportResourcesToDraftAppVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
