/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceResolutionStatusType {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    FAILED("Failed"),
    SUCCESS("Success"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceResolutionStatusType> VALUE_MAP;
    private final String value;

    private ResourceResolutionStatusType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceResolutionStatusType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceResolutionStatusType> knownValues() {
        EnumSet<ResourceResolutionStatusType> knownValues = EnumSet.allOf(ResourceResolutionStatusType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceResolutionStatusType.class, ResourceResolutionStatusType::toString);
    }
}

