/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppVersionAppComponentResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<UpdateAppVersionAppComponentResponse.Builder, UpdateAppVersionAppComponentResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(UpdateAppVersionAppComponentResponse::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<AppComponent> APP_COMPONENT_FIELD = SdkField.<AppComponent> builder(MarshallingType.SDK_POJO)
            .memberName("appComponent").getter(getter(UpdateAppVersionAppComponentResponse::appComponent))
            .setter(setter(Builder::appComponent)).constructor(AppComponent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponent").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(UpdateAppVersionAppComponentResponse::appVersion))
            .setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_COMPONENT_FIELD, APP_VERSION_FIELD));

    private final String appArn;

    private final AppComponent appComponent;

    private final String appVersion;

    private UpdateAppVersionAppComponentResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appComponent = builder.appComponent;
        this.appVersion = builder.appVersion;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * List of Application Components that belong to this resource.
     * </p>
     * 
     * @return List of Application Components that belong to this resource.
     */
    public final AppComponent appComponent() {
        return appComponent;
    }

    /**
     * <p>
     * Resilience Hub application version.
     * </p>
     * 
     * @return Resilience Hub application version.
     */
    public final String appVersion() {
        return appVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appComponent());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppVersionAppComponentResponse)) {
            return false;
        }
        UpdateAppVersionAppComponentResponse other = (UpdateAppVersionAppComponentResponse) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appComponent(), other.appComponent())
                && Objects.equals(appVersion(), other.appVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppVersionAppComponentResponse").add("AppArn", appArn())
                .add("AppComponent", appComponent()).add("AppVersion", appVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appComponent":
            return Optional.ofNullable(clazz.cast(appComponent()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppVersionAppComponentResponse, T> g) {
        return obj -> g.apply((UpdateAppVersionAppComponentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAppVersionAppComponentResponse> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * List of Application Components that belong to this resource.
         * </p>
         * 
         * @param appComponent
         *        List of Application Components that belong to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponent(AppComponent appComponent);

        /**
         * <p>
         * List of Application Components that belong to this resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppComponent.Builder} avoiding the need
         * to create one manually via {@link AppComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppComponent.Builder#build()} is called immediately and its
         * result is passed to {@link #appComponent(AppComponent)}.
         * 
         * @param appComponent
         *        a consumer that will call methods on {@link AppComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appComponent(AppComponent)
         */
        default Builder appComponent(Consumer<AppComponent.Builder> appComponent) {
            return appComponent(AppComponent.builder().applyMutation(appComponent).build());
        }

        /**
         * <p>
         * Resilience Hub application version.
         * </p>
         * 
         * @param appVersion
         *        Resilience Hub application version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private String appArn;

        private AppComponent appComponent;

        private String appVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppVersionAppComponentResponse model) {
            super(model);
            appArn(model.appArn);
            appComponent(model.appComponent);
            appVersion(model.appVersion);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final AppComponent.Builder getAppComponent() {
            return appComponent != null ? appComponent.toBuilder() : null;
        }

        public final void setAppComponent(AppComponent.BuilderImpl appComponent) {
            this.appComponent = appComponent != null ? appComponent.build() : null;
        }

        @Override
        public final Builder appComponent(AppComponent appComponent) {
            this.appComponent = appComponent;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @Override
        public UpdateAppVersionAppComponentResponse build() {
            return new UpdateAppVersionAppComponentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
