/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an application assessment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppAssessment implements SdkPojo, Serializable, ToCopyableBuilder<AppAssessment.Builder, AppAssessment> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(AppAssessment::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(AppAssessment::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentArn").getter(getter(AppAssessment::assessmentArn)).setter(setter(Builder::assessmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(AppAssessment::assessmentName)).setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()).build();

    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentStatus").getter(getter(AppAssessment::assessmentStatusAsString))
            .setter(setter(Builder::assessmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentStatus").build()).build();

    private static final SdkField<Map<String, DisruptionCompliance>> COMPLIANCE_FIELD = SdkField
            .<Map<String, DisruptionCompliance>> builder(MarshallingType.MAP)
            .memberName("compliance")
            .getter(getter(AppAssessment::complianceAsStrings))
            .setter(setter(Builder::complianceWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliance").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DisruptionCompliance> builder(MarshallingType.SDK_POJO)
                                            .constructor(DisruptionCompliance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceStatus").getter(getter(AppAssessment::complianceStatusAsString))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()).build();

    private static final SdkField<Cost> COST_FIELD = SdkField.<Cost> builder(MarshallingType.SDK_POJO).memberName("cost")
            .getter(getter(AppAssessment::cost)).setter(setter(Builder::cost)).constructor(Cost::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()).build();

    private static final SdkField<String> DRIFT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("driftStatus").getter(getter(AppAssessment::driftStatusAsString)).setter(setter(Builder::driftStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("driftStatus").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(AppAssessment::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> INVOKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("invoker")
            .getter(getter(AppAssessment::invokerAsString)).setter(setter(Builder::invoker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invoker").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(AppAssessment::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<ResiliencyPolicy> POLICY_FIELD = SdkField.<ResiliencyPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("policy").getter(getter(AppAssessment::policy)).setter(setter(Builder::policy))
            .constructor(ResiliencyPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<ResiliencyScore> RESILIENCY_SCORE_FIELD = SdkField
            .<ResiliencyScore> builder(MarshallingType.SDK_POJO).memberName("resiliencyScore")
            .getter(getter(AppAssessment::resiliencyScore)).setter(setter(Builder::resiliencyScore))
            .constructor(ResiliencyScore::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()).build();

    private static final SdkField<ResourceErrorsDetails> RESOURCE_ERRORS_DETAILS_FIELD = SdkField
            .<ResourceErrorsDetails> builder(MarshallingType.SDK_POJO).memberName("resourceErrorsDetails")
            .getter(getter(AppAssessment::resourceErrorsDetails)).setter(setter(Builder::resourceErrorsDetails))
            .constructor(ResourceErrorsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceErrorsDetails").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(AppAssessment::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AppAssessment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(AppAssessment::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, ASSESSMENT_ARN_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_STATUS_FIELD, COMPLIANCE_FIELD,
            COMPLIANCE_STATUS_FIELD, COST_FIELD, DRIFT_STATUS_FIELD, END_TIME_FIELD, INVOKER_FIELD, MESSAGE_FIELD, POLICY_FIELD,
            RESILIENCY_SCORE_FIELD, RESOURCE_ERRORS_DETAILS_FIELD, START_TIME_FIELD, TAGS_FIELD, VERSION_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appArn;

    private final String appVersion;

    private final String assessmentArn;

    private final String assessmentName;

    private final String assessmentStatus;

    private final Map<String, DisruptionCompliance> compliance;

    private final String complianceStatus;

    private final Cost cost;

    private final String driftStatus;

    private final Instant endTime;

    private final String invoker;

    private final String message;

    private final ResiliencyPolicy policy;

    private final ResiliencyScore resiliencyScore;

    private final ResourceErrorsDetails resourceErrorsDetails;

    private final Instant startTime;

    private final Map<String, String> tags;

    private final String versionName;

    private AppAssessment(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.assessmentArn = builder.assessmentArn;
        this.assessmentName = builder.assessmentName;
        this.assessmentStatus = builder.assessmentStatus;
        this.compliance = builder.compliance;
        this.complianceStatus = builder.complianceStatus;
        this.cost = builder.cost;
        this.driftStatus = builder.driftStatus;
        this.endTime = builder.endTime;
        this.invoker = builder.invoker;
        this.message = builder.message;
        this.policy = builder.policy;
        this.resiliencyScore = builder.resiliencyScore;
        this.resourceErrorsDetails = builder.resourceErrorsDetails;
        this.startTime = builder.startTime;
        this.tags = builder.tags;
        this.versionName = builder.versionName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Version of an application.
     * </p>
     * 
     * @return Version of an application.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information
     * about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
     * Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
     *         information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String assessmentArn() {
        return assessmentArn;
    }

    /**
     * <p>
     * Name of the assessment.
     * </p>
     * 
     * @return Name of the assessment.
     */
    public final String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * Current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assessmentStatus}
     * will return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assessmentStatusAsString}.
     * </p>
     * 
     * @return Current status of the assessment for the resiliency policy.
     * @see AssessmentStatus
     */
    public final AssessmentStatus assessmentStatus() {
        return AssessmentStatus.fromValue(assessmentStatus);
    }

    /**
     * <p>
     * Current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assessmentStatus}
     * will return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assessmentStatusAsString}.
     * </p>
     * 
     * @return Current status of the assessment for the resiliency policy.
     * @see AssessmentStatus
     */
    public final String assessmentStatusAsString() {
        return assessmentStatus;
    }

    /**
     * <p>
     * Application compliance against the resiliency policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompliance} method.
     * </p>
     * 
     * @return Application compliance against the resiliency policy.
     */
    public final Map<DisruptionType, DisruptionCompliance> compliance() {
        return AssessmentComplianceCopier.copyStringToEnum(compliance);
    }

    /**
     * For responses, this returns true if the service returned a value for the Compliance property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCompliance() {
        return compliance != null && !(compliance instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Application compliance against the resiliency policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompliance} method.
     * </p>
     * 
     * @return Application compliance against the resiliency policy.
     */
    public final Map<String, DisruptionCompliance> complianceAsStrings() {
        return compliance;
    }

    /**
     * <p>
     * Current status of the compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return Current status of the compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(complianceStatus);
    }

    /**
     * <p>
     * Current status of the compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return Current status of the compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final String complianceStatusAsString() {
        return complianceStatus;
    }

    /**
     * <p>
     * Cost for the application.
     * </p>
     * 
     * @return Cost for the application.
     */
    public final Cost cost() {
        return cost;
    }

    /**
     * <p>
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link DriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return Indicates if compliance drifts (deviations) were detected while running an assessment for your
     *         application.
     * @see DriftStatus
     */
    public final DriftStatus driftStatus() {
        return DriftStatus.fromValue(driftStatus);
    }

    /**
     * <p>
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #driftStatus} will
     * return {@link DriftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #driftStatusAsString}.
     * </p>
     * 
     * @return Indicates if compliance drifts (deviations) were detected while running an assessment for your
     *         application.
     * @see DriftStatus
     */
    public final String driftStatusAsString() {
        return driftStatus;
    }

    /**
     * <p>
     * End time for the action.
     * </p>
     * 
     * @return End time for the action.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The entity that invoked the assessment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoker} will
     * return {@link AssessmentInvoker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokerAsString}.
     * </p>
     * 
     * @return The entity that invoked the assessment.
     * @see AssessmentInvoker
     */
    public final AssessmentInvoker invoker() {
        return AssessmentInvoker.fromValue(invoker);
    }

    /**
     * <p>
     * The entity that invoked the assessment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoker} will
     * return {@link AssessmentInvoker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokerAsString}.
     * </p>
     * 
     * @return The entity that invoked the assessment.
     * @see AssessmentInvoker
     */
    public final String invokerAsString() {
        return invoker;
    }

    /**
     * <p>
     * Error or warning message from the assessment execution
     * </p>
     * 
     * @return Error or warning message from the assessment execution
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * Resiliency policy of an application.
     * </p>
     * 
     * @return Resiliency policy of an application.
     */
    public final ResiliencyPolicy policy() {
        return policy;
    }

    /**
     * <p>
     * Current resiliency score for an application.
     * </p>
     * 
     * @return Current resiliency score for an application.
     */
    public final ResiliencyScore resiliencyScore() {
        return resiliencyScore;
    }

    /**
     * <p>
     * A resource error object containing a list of errors retrieving an application's resources.
     * </p>
     * 
     * @return A resource error object containing a list of errors retrieving an application's resources.
     */
    public final ResourceErrorsDetails resourceErrorsDetails() {
        return resourceErrorsDetails;
    }

    /**
     * <p>
     * Starting time for the action.
     * </p>
     * 
     * @return Starting time for the action.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key/value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each
     *         tag consists of a key/value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Version name of the published application.
     * </p>
     * 
     * @return Version name of the published application.
     */
    public final String versionName() {
        return versionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCompliance() ? complianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        hashCode = 31 * hashCode + Objects.hashCode(driftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(invokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(resourceErrorsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppAssessment)) {
            return false;
        }
        AppAssessment other = (AppAssessment) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(assessmentArn(), other.assessmentArn())
                && Objects.equals(assessmentName(), other.assessmentName())
                && Objects.equals(assessmentStatusAsString(), other.assessmentStatusAsString())
                && hasCompliance() == other.hasCompliance() && Objects.equals(complianceAsStrings(), other.complianceAsStrings())
                && Objects.equals(complianceStatusAsString(), other.complianceStatusAsString())
                && Objects.equals(cost(), other.cost()) && Objects.equals(driftStatusAsString(), other.driftStatusAsString())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(invokerAsString(), other.invokerAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(policy(), other.policy())
                && Objects.equals(resiliencyScore(), other.resiliencyScore())
                && Objects.equals(resourceErrorsDetails(), other.resourceErrorsDetails())
                && Objects.equals(startTime(), other.startTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(versionName(), other.versionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppAssessment").add("AppArn", appArn()).add("AppVersion", appVersion())
                .add("AssessmentArn", assessmentArn()).add("AssessmentName", assessmentName())
                .add("AssessmentStatus", assessmentStatusAsString())
                .add("Compliance", hasCompliance() ? complianceAsStrings() : null)
                .add("ComplianceStatus", complianceStatusAsString()).add("Cost", cost())
                .add("DriftStatus", driftStatusAsString()).add("EndTime", endTime()).add("Invoker", invokerAsString())
                .add("Message", message()).add("Policy", policy()).add("ResiliencyScore", resiliencyScore())
                .add("ResourceErrorsDetails", resourceErrorsDetails()).add("StartTime", startTime())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").add("VersionName", versionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "assessmentArn":
            return Optional.ofNullable(clazz.cast(assessmentArn()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "assessmentStatus":
            return Optional.ofNullable(clazz.cast(assessmentStatusAsString()));
        case "compliance":
            return Optional.ofNullable(clazz.cast(complianceAsStrings()));
        case "complianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatusAsString()));
        case "cost":
            return Optional.ofNullable(clazz.cast(cost()));
        case "driftStatus":
            return Optional.ofNullable(clazz.cast(driftStatusAsString()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "invoker":
            return Optional.ofNullable(clazz.cast(invokerAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "resiliencyScore":
            return Optional.ofNullable(clazz.cast(resiliencyScore()));
        case "resourceErrorsDetails":
            return Optional.ofNullable(clazz.cast(resourceErrorsDetails()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppAssessment, T> g) {
        return obj -> g.apply((AppAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppAssessment> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Version of an application.
         * </p>
         * 
         * @param appVersion
         *        Version of an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param assessmentArn
         *        Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         *        :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
         *        information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentArn(String assessmentArn);

        /**
         * <p>
         * Name of the assessment.
         * </p>
         * 
         * @param assessmentName
         *        Name of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * Current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        Current status of the assessment for the resiliency policy.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder assessmentStatus(String assessmentStatus);

        /**
         * <p>
         * Current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        Current status of the assessment for the resiliency policy.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder assessmentStatus(AssessmentStatus assessmentStatus);

        /**
         * <p>
         * Application compliance against the resiliency policy.
         * </p>
         * 
         * @param compliance
         *        Application compliance against the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance);

        /**
         * <p>
         * Application compliance against the resiliency policy.
         * </p>
         * 
         * @param compliance
         *        Application compliance against the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance);

        /**
         * <p>
         * Current status of the compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        Current status of the compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(String complianceStatus);

        /**
         * <p>
         * Current status of the compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        Current status of the compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(ComplianceStatus complianceStatus);

        /**
         * <p>
         * Cost for the application.
         * </p>
         * 
         * @param cost
         *        Cost for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(Cost cost);

        /**
         * <p>
         * Cost for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cost.Builder} avoiding the need to create
         * one manually via {@link Cost#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cost.Builder#build()} is called immediately and its result is
         * passed to {@link #cost(Cost)}.
         * 
         * @param cost
         *        a consumer that will call methods on {@link Cost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cost(Cost)
         */
        default Builder cost(Consumer<Cost.Builder> cost) {
            return cost(Cost.builder().applyMutation(cost).build());
        }

        /**
         * <p>
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         * </p>
         * 
         * @param driftStatus
         *        Indicates if compliance drifts (deviations) were detected while running an assessment for your
         *        application.
         * @see DriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftStatus
         */
        Builder driftStatus(String driftStatus);

        /**
         * <p>
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         * </p>
         * 
         * @param driftStatus
         *        Indicates if compliance drifts (deviations) were detected while running an assessment for your
         *        application.
         * @see DriftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DriftStatus
         */
        Builder driftStatus(DriftStatus driftStatus);

        /**
         * <p>
         * End time for the action.
         * </p>
         * 
         * @param endTime
         *        End time for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The entity that invoked the assessment.
         * </p>
         * 
         * @param invoker
         *        The entity that invoked the assessment.
         * @see AssessmentInvoker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentInvoker
         */
        Builder invoker(String invoker);

        /**
         * <p>
         * The entity that invoked the assessment.
         * </p>
         * 
         * @param invoker
         *        The entity that invoked the assessment.
         * @see AssessmentInvoker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentInvoker
         */
        Builder invoker(AssessmentInvoker invoker);

        /**
         * <p>
         * Error or warning message from the assessment execution
         * </p>
         * 
         * @param message
         *        Error or warning message from the assessment execution
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * Resiliency policy of an application.
         * </p>
         * 
         * @param policy
         *        Resiliency policy of an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(ResiliencyPolicy policy);

        /**
         * <p>
         * Resiliency policy of an application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResiliencyPolicy.Builder} avoiding the
         * need to create one manually via {@link ResiliencyPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResiliencyPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #policy(ResiliencyPolicy)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link ResiliencyPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(ResiliencyPolicy)
         */
        default Builder policy(Consumer<ResiliencyPolicy.Builder> policy) {
            return policy(ResiliencyPolicy.builder().applyMutation(policy).build());
        }

        /**
         * <p>
         * Current resiliency score for an application.
         * </p>
         * 
         * @param resiliencyScore
         *        Current resiliency score for an application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resiliencyScore(ResiliencyScore resiliencyScore);

        /**
         * <p>
         * Current resiliency score for an application.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResiliencyScore.Builder} avoiding the
         * need to create one manually via {@link ResiliencyScore#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResiliencyScore.Builder#build()} is called immediately and its
         * result is passed to {@link #resiliencyScore(ResiliencyScore)}.
         * 
         * @param resiliencyScore
         *        a consumer that will call methods on {@link ResiliencyScore.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resiliencyScore(ResiliencyScore)
         */
        default Builder resiliencyScore(Consumer<ResiliencyScore.Builder> resiliencyScore) {
            return resiliencyScore(ResiliencyScore.builder().applyMutation(resiliencyScore).build());
        }

        /**
         * <p>
         * A resource error object containing a list of errors retrieving an application's resources.
         * </p>
         * 
         * @param resourceErrorsDetails
         *        A resource error object containing a list of errors retrieving an application's resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceErrorsDetails(ResourceErrorsDetails resourceErrorsDetails);

        /**
         * <p>
         * A resource error object containing a list of errors retrieving an application's resources.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceErrorsDetails.Builder} avoiding
         * the need to create one manually via {@link ResourceErrorsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceErrorsDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceErrorsDetails(ResourceErrorsDetails)}.
         * 
         * @param resourceErrorsDetails
         *        a consumer that will call methods on {@link ResourceErrorsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceErrorsDetails(ResourceErrorsDetails)
         */
        default Builder resourceErrorsDetails(Consumer<ResourceErrorsDetails.Builder> resourceErrorsDetails) {
            return resourceErrorsDetails(ResourceErrorsDetails.builder().applyMutation(resourceErrorsDetails).build());
        }

        /**
         * <p>
         * Starting time for the action.
         * </p>
         * 
         * @param startTime
         *        Starting time for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
         * consists of a key/value pair.
         * </p>
         * 
         * @param tags
         *        Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
         *        Each tag consists of a key/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Version name of the published application.
         * </p>
         * 
         * @param versionName
         *        Version name of the published application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);
    }

    static final class BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private String assessmentArn;

        private String assessmentName;

        private String assessmentStatus;

        private Map<String, DisruptionCompliance> compliance = DefaultSdkAutoConstructMap.getInstance();

        private String complianceStatus;

        private Cost cost;

        private String driftStatus;

        private Instant endTime;

        private String invoker;

        private String message;

        private ResiliencyPolicy policy;

        private ResiliencyScore resiliencyScore;

        private ResourceErrorsDetails resourceErrorsDetails;

        private Instant startTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String versionName;

        private BuilderImpl() {
        }

        private BuilderImpl(AppAssessment model) {
            appArn(model.appArn);
            appVersion(model.appVersion);
            assessmentArn(model.assessmentArn);
            assessmentName(model.assessmentName);
            assessmentStatus(model.assessmentStatus);
            complianceWithStrings(model.compliance);
            complianceStatus(model.complianceStatus);
            cost(model.cost);
            driftStatus(model.driftStatus);
            endTime(model.endTime);
            invoker(model.invoker);
            message(model.message);
            policy(model.policy);
            resiliencyScore(model.resiliencyScore);
            resourceErrorsDetails(model.resourceErrorsDetails);
            startTime(model.startTime);
            tags(model.tags);
            versionName(model.versionName);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getAssessmentArn() {
            return assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentStatus() {
            return assessmentStatus;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        @Override
        public final Builder assessmentStatus(AssessmentStatus assessmentStatus) {
            this.assessmentStatus(assessmentStatus == null ? null : assessmentStatus.toString());
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getCompliance() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.compliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompliance(Map<String, DisruptionCompliance.BuilderImpl> compliance) {
            this.compliance = AssessmentComplianceCopier.copyFromBuilder(compliance);
        }

        @Override
        public final Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copy(compliance);
            return this;
        }

        @Override
        public final Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copyEnumToString(compliance);
            return this;
        }

        public final String getComplianceStatus() {
            return complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Cost.Builder getCost() {
            return cost != null ? cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final String getDriftStatus() {
            return driftStatus;
        }

        public final void setDriftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
        }

        @Override
        public final Builder driftStatus(String driftStatus) {
            this.driftStatus = driftStatus;
            return this;
        }

        @Override
        public final Builder driftStatus(DriftStatus driftStatus) {
            this.driftStatus(driftStatus == null ? null : driftStatus.toString());
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getInvoker() {
            return invoker;
        }

        public final void setInvoker(String invoker) {
            this.invoker = invoker;
        }

        @Override
        public final Builder invoker(String invoker) {
            this.invoker = invoker;
            return this;
        }

        @Override
        public final Builder invoker(AssessmentInvoker invoker) {
            this.invoker(invoker == null ? null : invoker.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final ResiliencyPolicy.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(ResiliencyPolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(ResiliencyPolicy policy) {
            this.policy = policy;
            return this;
        }

        public final ResiliencyScore.Builder getResiliencyScore() {
            return resiliencyScore != null ? resiliencyScore.toBuilder() : null;
        }

        public final void setResiliencyScore(ResiliencyScore.BuilderImpl resiliencyScore) {
            this.resiliencyScore = resiliencyScore != null ? resiliencyScore.build() : null;
        }

        @Override
        public final Builder resiliencyScore(ResiliencyScore resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final ResourceErrorsDetails.Builder getResourceErrorsDetails() {
            return resourceErrorsDetails != null ? resourceErrorsDetails.toBuilder() : null;
        }

        public final void setResourceErrorsDetails(ResourceErrorsDetails.BuilderImpl resourceErrorsDetails) {
            this.resourceErrorsDetails = resourceErrorsDetails != null ? resourceErrorsDetails.build() : null;
        }

        @Override
        public final Builder resourceErrorsDetails(ResourceErrorsDetails resourceErrorsDetails) {
            this.resourceErrorsDetails = resourceErrorsDetails;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        @Override
        public AppAssessment build() {
            return new AppAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
