/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAlarmRecommendationsResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListAlarmRecommendationsResponse.Builder, ListAlarmRecommendationsResponse> {
    private static final SdkField<List<AlarmRecommendation>> ALARM_RECOMMENDATIONS_FIELD = SdkField
            .<List<AlarmRecommendation>> builder(MarshallingType.LIST)
            .memberName("alarmRecommendations")
            .getter(getter(ListAlarmRecommendationsResponse::alarmRecommendations))
            .setter(setter(Builder::alarmRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlarmRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlarmRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAlarmRecommendationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_RECOMMENDATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AlarmRecommendation> alarmRecommendations;

    private final String nextToken;

    private ListAlarmRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.alarmRecommendations = builder.alarmRecommendations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlarmRecommendations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlarmRecommendations() {
        return alarmRecommendations != null && !(alarmRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object includes
     * Application Component names, descriptions, information about whether a recommendation has already been
     * implemented or not, prerequisites, and more.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlarmRecommendations} method.
     * </p>
     * 
     * @return The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object
     *         includes Application Component names, descriptions, information about whether a recommendation has
     *         already been implemented or not, prerequisites, and more.
     */
    public final List<AlarmRecommendation> alarmRecommendations() {
        return alarmRecommendations;
    }

    /**
     * <p>
     * The token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlarmRecommendations() ? alarmRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlarmRecommendationsResponse)) {
            return false;
        }
        ListAlarmRecommendationsResponse other = (ListAlarmRecommendationsResponse) obj;
        return hasAlarmRecommendations() == other.hasAlarmRecommendations()
                && Objects.equals(alarmRecommendations(), other.alarmRecommendations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAlarmRecommendationsResponse")
                .add("AlarmRecommendations", hasAlarmRecommendations() ? alarmRecommendations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alarmRecommendations":
            return Optional.ofNullable(clazz.cast(alarmRecommendations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAlarmRecommendationsResponse, T> g) {
        return obj -> g.apply((ListAlarmRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAlarmRecommendationsResponse> {
        /**
         * <p>
         * The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object includes
         * Application Component names, descriptions, information about whether a recommendation has already been
         * implemented or not, prerequisites, and more.
         * </p>
         * 
         * @param alarmRecommendations
         *        The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object
         *        includes Application Component names, descriptions, information about whether a recommendation has
         *        already been implemented or not, prerequisites, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRecommendations(Collection<AlarmRecommendation> alarmRecommendations);

        /**
         * <p>
         * The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object includes
         * Application Component names, descriptions, information about whether a recommendation has already been
         * implemented or not, prerequisites, and more.
         * </p>
         * 
         * @param alarmRecommendations
         *        The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object
         *        includes Application Component names, descriptions, information about whether a recommendation has
         *        already been implemented or not, prerequisites, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmRecommendations(AlarmRecommendation... alarmRecommendations);

        /**
         * <p>
         * The alarm recommendations for an AWS Resilience Hub application, returned as an object. This object includes
         * Application Component names, descriptions, information about whether a recommendation has already been
         * implemented or not, prerequisites, and more.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.AlarmRecommendation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.AlarmRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.AlarmRecommendation.Builder#build()} is called
         * immediately and its result is passed to {@link #alarmRecommendations(List<AlarmRecommendation>)}.
         * 
         * @param alarmRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.AlarmRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarmRecommendations(java.util.Collection<AlarmRecommendation>)
         */
        Builder alarmRecommendations(Consumer<AlarmRecommendation.Builder>... alarmRecommendations);

        /**
         * <p>
         * The token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private List<AlarmRecommendation> alarmRecommendations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlarmRecommendationsResponse model) {
            super(model);
            alarmRecommendations(model.alarmRecommendations);
            nextToken(model.nextToken);
        }

        public final List<AlarmRecommendation.Builder> getAlarmRecommendations() {
            List<AlarmRecommendation.Builder> result = AlarmRecommendationListCopier.copyToBuilder(this.alarmRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlarmRecommendations(Collection<AlarmRecommendation.BuilderImpl> alarmRecommendations) {
            this.alarmRecommendations = AlarmRecommendationListCopier.copyFromBuilder(alarmRecommendations);
        }

        @Override
        public final Builder alarmRecommendations(Collection<AlarmRecommendation> alarmRecommendations) {
            this.alarmRecommendations = AlarmRecommendationListCopier.copy(alarmRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmRecommendations(AlarmRecommendation... alarmRecommendations) {
            alarmRecommendations(Arrays.asList(alarmRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmRecommendations(Consumer<AlarmRecommendation.Builder>... alarmRecommendations) {
            alarmRecommendations(Stream.of(alarmRecommendations).map(c -> AlarmRecommendation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlarmRecommendationsResponse build() {
            return new ListAlarmRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
