/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an application assessment summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppAssessmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AppAssessmentSummary.Builder, AppAssessmentSummary> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(AppAssessmentSummary::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appVersion").getter(getter(AppAssessmentSummary::appVersion)).setter(setter(Builder::appVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()).build();

    private static final SdkField<String> ASSESSMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentArn").getter(getter(AppAssessmentSummary::assessmentArn))
            .setter(setter(Builder::assessmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentArn").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(AppAssessmentSummary::assessmentName))
            .setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentName").build()).build();

    private static final SdkField<String> ASSESSMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentStatus").getter(getter(AppAssessmentSummary::assessmentStatusAsString))
            .setter(setter(Builder::assessmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentStatus").build()).build();

    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceStatus").getter(getter(AppAssessmentSummary::complianceStatusAsString))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()).build();

    private static final SdkField<Cost> COST_FIELD = SdkField.<Cost> builder(MarshallingType.SDK_POJO).memberName("cost")
            .getter(getter(AppAssessmentSummary::cost)).setter(setter(Builder::cost)).constructor(Cost::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(AppAssessmentSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> INVOKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("invoker")
            .getter(getter(AppAssessmentSummary::invokerAsString)).setter(setter(Builder::invoker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invoker").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(AppAssessmentSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<Double> RESILIENCY_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("resiliencyScore").getter(getter(AppAssessmentSummary::resiliencyScore))
            .setter(setter(Builder::resiliencyScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(AppAssessmentSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_VERSION_FIELD, ASSESSMENT_ARN_FIELD, ASSESSMENT_NAME_FIELD, ASSESSMENT_STATUS_FIELD, COMPLIANCE_STATUS_FIELD,
            COST_FIELD, END_TIME_FIELD, INVOKER_FIELD, MESSAGE_FIELD, RESILIENCY_SCORE_FIELD, START_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appArn;

    private final String appVersion;

    private final String assessmentArn;

    private final String assessmentName;

    private final String assessmentStatus;

    private final String complianceStatus;

    private final Cost cost;

    private final Instant endTime;

    private final String invoker;

    private final String message;

    private final Double resiliencyScore;

    private final Instant startTime;

    private AppAssessmentSummary(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.assessmentArn = builder.assessmentArn;
        this.assessmentName = builder.assessmentName;
        this.assessmentStatus = builder.assessmentStatus;
        this.complianceStatus = builder.complianceStatus;
        this.cost = builder.cost;
        this.endTime = builder.endTime;
        this.invoker = builder.invoker;
        this.message = builder.message;
        this.resiliencyScore = builder.resiliencyScore;
        this.startTime = builder.startTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public final String appVersion() {
        return appVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more information
     * about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon
     * Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
     *         :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
     *         information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String assessmentArn() {
        return assessmentArn;
    }

    /**
     * <p>
     * The name of the assessment.
     * </p>
     * 
     * @return The name of the assessment.
     */
    public final String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * The current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assessmentStatus}
     * will return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assessmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the assessment for the resiliency policy.
     * @see AssessmentStatus
     */
    public final AssessmentStatus assessmentStatus() {
        return AssessmentStatus.fromValue(assessmentStatus);
    }

    /**
     * <p>
     * The current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assessmentStatus}
     * will return {@link AssessmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assessmentStatusAsString}.
     * </p>
     * 
     * @return The current status of the assessment for the resiliency policy.
     * @see AssessmentStatus
     */
    public final String assessmentStatusAsString() {
        return assessmentStatus;
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(complianceStatus);
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final String complianceStatusAsString() {
        return complianceStatus;
    }

    /**
     * <p>
     * The cost for the application.
     * </p>
     * 
     * @return The cost for the application.
     */
    public final Cost cost() {
        return cost;
    }

    /**
     * <p>
     * The end time for the action.
     * </p>
     * 
     * @return The end time for the action.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The entity that invoked the assessment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoker} will
     * return {@link AssessmentInvoker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokerAsString}.
     * </p>
     * 
     * @return The entity that invoked the assessment.
     * @see AssessmentInvoker
     */
    public final AssessmentInvoker invoker() {
        return AssessmentInvoker.fromValue(invoker);
    }

    /**
     * <p>
     * The entity that invoked the assessment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoker} will
     * return {@link AssessmentInvoker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokerAsString}.
     * </p>
     * 
     * @return The entity that invoked the assessment.
     * @see AssessmentInvoker
     */
    public final String invokerAsString() {
        return invoker;
    }

    /**
     * <p>
     * The message from the assessment run.
     * </p>
     * 
     * @return The message from the assessment run.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The current resiliency score for the application.
     * </p>
     * 
     * @return The current resiliency score for the application.
     */
    public final Double resiliencyScore() {
        return resiliencyScore;
    }

    /**
     * <p>
     * The starting time for the action.
     * </p>
     * 
     * @return The starting time for the action.
     */
    public final Instant startTime() {
        return startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(invokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppAssessmentSummary)) {
            return false;
        }
        AppAssessmentSummary other = (AppAssessmentSummary) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appVersion(), other.appVersion())
                && Objects.equals(assessmentArn(), other.assessmentArn())
                && Objects.equals(assessmentName(), other.assessmentName())
                && Objects.equals(assessmentStatusAsString(), other.assessmentStatusAsString())
                && Objects.equals(complianceStatusAsString(), other.complianceStatusAsString())
                && Objects.equals(cost(), other.cost()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(invokerAsString(), other.invokerAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(resiliencyScore(), other.resiliencyScore()) && Objects.equals(startTime(), other.startTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppAssessmentSummary").add("AppArn", appArn()).add("AppVersion", appVersion())
                .add("AssessmentArn", assessmentArn()).add("AssessmentName", assessmentName())
                .add("AssessmentStatus", assessmentStatusAsString()).add("ComplianceStatus", complianceStatusAsString())
                .add("Cost", cost()).add("EndTime", endTime()).add("Invoker", invokerAsString()).add("Message", message())
                .add("ResiliencyScore", resiliencyScore()).add("StartTime", startTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appVersion":
            return Optional.ofNullable(clazz.cast(appVersion()));
        case "assessmentArn":
            return Optional.ofNullable(clazz.cast(assessmentArn()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "assessmentStatus":
            return Optional.ofNullable(clazz.cast(assessmentStatusAsString()));
        case "complianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatusAsString()));
        case "cost":
            return Optional.ofNullable(clazz.cast(cost()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "invoker":
            return Optional.ofNullable(clazz.cast(invokerAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "resiliencyScore":
            return Optional.ofNullable(clazz.cast(resiliencyScore()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppAssessmentSummary, T> g) {
        return obj -> g.apply((AppAssessmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppAssessmentSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param appVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appVersion(String appVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:app-assessment/<code>app-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param assessmentArn
         *        The Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app-assessment/
         *        <code>app-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentArn(String assessmentArn);

        /**
         * <p>
         * The name of the assessment.
         * </p>
         * 
         * @param assessmentName
         *        The name of the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder assessmentStatus(String assessmentStatus);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @see AssessmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentStatus
         */
        Builder assessmentStatus(AssessmentStatus assessmentStatus);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(String complianceStatus);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(ComplianceStatus complianceStatus);

        /**
         * <p>
         * The cost for the application.
         * </p>
         * 
         * @param cost
         *        The cost for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(Cost cost);

        /**
         * <p>
         * The cost for the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link Cost.Builder} avoiding the need to create
         * one manually via {@link Cost#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Cost.Builder#build()} is called immediately and its result is
         * passed to {@link #cost(Cost)}.
         * 
         * @param cost
         *        a consumer that will call methods on {@link Cost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cost(Cost)
         */
        default Builder cost(Consumer<Cost.Builder> cost) {
            return cost(Cost.builder().applyMutation(cost).build());
        }

        /**
         * <p>
         * The end time for the action.
         * </p>
         * 
         * @param endTime
         *        The end time for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The entity that invoked the assessment.
         * </p>
         * 
         * @param invoker
         *        The entity that invoked the assessment.
         * @see AssessmentInvoker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentInvoker
         */
        Builder invoker(String invoker);

        /**
         * <p>
         * The entity that invoked the assessment.
         * </p>
         * 
         * @param invoker
         *        The entity that invoked the assessment.
         * @see AssessmentInvoker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentInvoker
         */
        Builder invoker(AssessmentInvoker invoker);

        /**
         * <p>
         * The message from the assessment run.
         * </p>
         * 
         * @param message
         *        The message from the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The current resiliency score for the application.
         * </p>
         * 
         * @param resiliencyScore
         *        The current resiliency score for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resiliencyScore(Double resiliencyScore);

        /**
         * <p>
         * The starting time for the action.
         * </p>
         * 
         * @param startTime
         *        The starting time for the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);
    }

    static final class BuilderImpl implements Builder {
        private String appArn;

        private String appVersion;

        private String assessmentArn;

        private String assessmentName;

        private String assessmentStatus;

        private String complianceStatus;

        private Cost cost;

        private Instant endTime;

        private String invoker;

        private String message;

        private Double resiliencyScore;

        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AppAssessmentSummary model) {
            appArn(model.appArn);
            appVersion(model.appVersion);
            assessmentArn(model.assessmentArn);
            assessmentName(model.assessmentName);
            assessmentStatus(model.assessmentStatus);
            complianceStatus(model.complianceStatus);
            cost(model.cost);
            endTime(model.endTime);
            invoker(model.invoker);
            message(model.message);
            resiliencyScore(model.resiliencyScore);
            startTime(model.startTime);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getAssessmentArn() {
            return assessmentArn;
        }

        public final void setAssessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
        }

        @Override
        public final Builder assessmentArn(String assessmentArn) {
            this.assessmentArn = assessmentArn;
            return this;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final String getAssessmentStatus() {
            return assessmentStatus;
        }

        public final void setAssessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
        }

        @Override
        public final Builder assessmentStatus(String assessmentStatus) {
            this.assessmentStatus = assessmentStatus;
            return this;
        }

        @Override
        public final Builder assessmentStatus(AssessmentStatus assessmentStatus) {
            this.assessmentStatus(assessmentStatus == null ? null : assessmentStatus.toString());
            return this;
        }

        public final String getComplianceStatus() {
            return complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Cost.Builder getCost() {
            return cost != null ? cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getInvoker() {
            return invoker;
        }

        public final void setInvoker(String invoker) {
            this.invoker = invoker;
        }

        @Override
        public final Builder invoker(String invoker) {
            this.invoker = invoker;
            return this;
        }

        @Override
        public final Builder invoker(AssessmentInvoker invoker) {
            this.invoker(invoker == null ? null : invoker.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Double getResiliencyScore() {
            return resiliencyScore;
        }

        public final void setResiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
        }

        @Override
        public final Builder resiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        @Override
        public AppAssessmentSummary build() {
            return new AppAssessmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
