/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppAssessmentsRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<ListAppAssessmentsRequest.Builder, ListAppAssessmentsRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(ListAppAssessmentsRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("appArn").build()).build();

    private static final SdkField<String> ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentName").getter(getter(ListAppAssessmentsRequest::assessmentName))
            .setter(setter(Builder::assessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assessmentName").build())
            .build();

    private static final SdkField<List<String>> ASSESSMENT_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("assessmentStatus")
            .getter(getter(ListAppAssessmentsRequest::assessmentStatusAsStrings))
            .setter(setter(Builder::assessmentStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assessmentStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceStatus").getter(getter(ListAppAssessmentsRequest::complianceStatusAsString))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("complianceStatus").build())
            .build();

    private static final SdkField<String> INVOKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("invoker")
            .getter(getter(ListAppAssessmentsRequest::invokerAsString)).setter(setter(Builder::invoker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("invoker").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListAppAssessmentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppAssessmentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Boolean> REVERSE_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("reverseOrder").getter(getter(ListAppAssessmentsRequest::reverseOrder))
            .setter(setter(Builder::reverseOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reverseOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            ASSESSMENT_NAME_FIELD, ASSESSMENT_STATUS_FIELD, COMPLIANCE_STATUS_FIELD, INVOKER_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, REVERSE_ORDER_FIELD));

    private final String appArn;

    private final String assessmentName;

    private final List<String> assessmentStatus;

    private final String complianceStatus;

    private final String invoker;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean reverseOrder;

    private ListAppAssessmentsRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.assessmentName = builder.assessmentName;
        this.assessmentStatus = builder.assessmentStatus;
        this.complianceStatus = builder.complianceStatus;
        this.invoker = builder.invoker;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.reverseOrder = builder.reverseOrder;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * The name for the assessment.
     * </p>
     * 
     * @return The name for the assessment.
     */
    public final String assessmentName() {
        return assessmentName;
    }

    /**
     * <p>
     * The current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentStatus} method.
     * </p>
     * 
     * @return The current status of the assessment for the resiliency policy.
     */
    public final List<AssessmentStatus> assessmentStatus() {
        return AssessmentStatusListCopier.copyStringToEnum(assessmentStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the AssessmentStatus property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssessmentStatus() {
        return assessmentStatus != null && !(assessmentStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The current status of the assessment for the resiliency policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssessmentStatus} method.
     * </p>
     * 
     * @return The current status of the assessment for the resiliency policy.
     */
    public final List<String> assessmentStatusAsStrings() {
        return assessmentStatus;
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final ComplianceStatus complianceStatus() {
        return ComplianceStatus.fromValue(complianceStatus);
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link ComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see ComplianceStatus
     */
    public final String complianceStatusAsString() {
        return complianceStatus;
    }

    /**
     * <p>
     * Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoker} will
     * return {@link AssessmentInvoker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokerAsString}.
     * </p>
     * 
     * @return Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
     *         <code>System</code>.
     * @see AssessmentInvoker
     */
    public final AssessmentInvoker invoker() {
        return AssessmentInvoker.fromValue(invoker);
    }

    /**
     * <p>
     * Specifies the entity that invoked a specific assessment, either a <code>User</code> or the <code>System</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invoker} will
     * return {@link AssessmentInvoker#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #invokerAsString}.
     * </p>
     * 
     * @return Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
     *         <code>System</code>.
     * @see AssessmentInvoker
     */
    public final String invokerAsString() {
        return invoker;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the specified
     * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     * retrieved.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the specified
     *         <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
     *         retrieved.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Null, or the token from a previous call to get the next set of results.
     * </p>
     * 
     * @return Null, or the token from a previous call to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set reverseOrder to
     * <code>true</code>.
     * </p>
     * 
     * @return The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set
     *         reverseOrder to <code>true</code>.
     */
    public final Boolean reverseOrder() {
        return reverseOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssessmentStatus() ? assessmentStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(invokerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(reverseOrder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppAssessmentsRequest)) {
            return false;
        }
        ListAppAssessmentsRequest other = (ListAppAssessmentsRequest) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(assessmentName(), other.assessmentName())
                && hasAssessmentStatus() == other.hasAssessmentStatus()
                && Objects.equals(assessmentStatusAsStrings(), other.assessmentStatusAsStrings())
                && Objects.equals(complianceStatusAsString(), other.complianceStatusAsString())
                && Objects.equals(invokerAsString(), other.invokerAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(reverseOrder(), other.reverseOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppAssessmentsRequest").add("AppArn", appArn()).add("AssessmentName", assessmentName())
                .add("AssessmentStatus", hasAssessmentStatus() ? assessmentStatusAsStrings() : null)
                .add("ComplianceStatus", complianceStatusAsString()).add("Invoker", invokerAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("ReverseOrder", reverseOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "assessmentName":
            return Optional.ofNullable(clazz.cast(assessmentName()));
        case "assessmentStatus":
            return Optional.ofNullable(clazz.cast(assessmentStatusAsStrings()));
        case "complianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatusAsString()));
        case "invoker":
            return Optional.ofNullable(clazz.cast(invokerAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "reverseOrder":
            return Optional.ofNullable(clazz.cast(reverseOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppAssessmentsRequest, T> g) {
        return obj -> g.apply((ListAppAssessmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAppAssessmentsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * The name for the assessment.
         * </p>
         * 
         * @param assessmentName
         *        The name for the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentName(String assessmentName);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentStatusWithStrings(Collection<String> assessmentStatus);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentStatusWithStrings(String... assessmentStatus);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentStatus(Collection<AssessmentStatus> assessmentStatus);

        /**
         * <p>
         * The current status of the assessment for the resiliency policy.
         * </p>
         * 
         * @param assessmentStatus
         *        The current status of the assessment for the resiliency policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentStatus(AssessmentStatus... assessmentStatus);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(String complianceStatus);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see ComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComplianceStatus
         */
        Builder complianceStatus(ComplianceStatus complianceStatus);

        /**
         * <p>
         * Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
         * <code>System</code>.
         * </p>
         * 
         * @param invoker
         *        Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
         *        <code>System</code>.
         * @see AssessmentInvoker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentInvoker
         */
        Builder invoker(String invoker);

        /**
         * <p>
         * Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
         * <code>System</code>.
         * </p>
         * 
         * @param invoker
         *        Specifies the entity that invoked a specific assessment, either a <code>User</code> or the
         *        <code>System</code>.
         * @see AssessmentInvoker
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssessmentInvoker
         */
        Builder invoker(AssessmentInvoker invoker);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the specified
         * <code>MaxResults</code> value, a token is included in the response so that the remaining results can be
         * retrieved.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the specified
         *        <code>MaxResults</code> value, a token is included in the response so that the remaining results can
         *        be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Null, or the token from a previous call to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        Null, or the token from a previous call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set
         * reverseOrder to <code>true</code>.
         * </p>
         * 
         * @param reverseOrder
         *        The default is to sort by ascending <b>startTime</b>. To sort by descending <b>startTime</b>, set
         *        reverseOrder to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reverseOrder(Boolean reverseOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private String assessmentName;

        private List<String> assessmentStatus = DefaultSdkAutoConstructList.getInstance();

        private String complianceStatus;

        private String invoker;

        private Integer maxResults;

        private String nextToken;

        private Boolean reverseOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppAssessmentsRequest model) {
            super(model);
            appArn(model.appArn);
            assessmentName(model.assessmentName);
            assessmentStatusWithStrings(model.assessmentStatus);
            complianceStatus(model.complianceStatus);
            invoker(model.invoker);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            reverseOrder(model.reverseOrder);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentName() {
            return assessmentName;
        }

        public final void setAssessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
        }

        @Override
        public final Builder assessmentName(String assessmentName) {
            this.assessmentName = assessmentName;
            return this;
        }

        public final Collection<String> getAssessmentStatus() {
            if (assessmentStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return assessmentStatus;
        }

        public final void setAssessmentStatus(Collection<String> assessmentStatus) {
            this.assessmentStatus = AssessmentStatusListCopier.copy(assessmentStatus);
        }

        @Override
        public final Builder assessmentStatusWithStrings(Collection<String> assessmentStatus) {
            this.assessmentStatus = AssessmentStatusListCopier.copy(assessmentStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentStatusWithStrings(String... assessmentStatus) {
            assessmentStatusWithStrings(Arrays.asList(assessmentStatus));
            return this;
        }

        @Override
        public final Builder assessmentStatus(Collection<AssessmentStatus> assessmentStatus) {
            this.assessmentStatus = AssessmentStatusListCopier.copyEnumToString(assessmentStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentStatus(AssessmentStatus... assessmentStatus) {
            assessmentStatus(Arrays.asList(assessmentStatus));
            return this;
        }

        public final String getComplianceStatus() {
            return complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(ComplianceStatus complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final String getInvoker() {
            return invoker;
        }

        public final void setInvoker(String invoker) {
            this.invoker = invoker;
        }

        @Override
        public final Builder invoker(String invoker) {
            this.invoker = invoker;
            return this;
        }

        @Override
        public final Builder invoker(AssessmentInvoker invoker) {
            this.invoker(invoker == null ? null : invoker.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getReverseOrder() {
            return reverseOrder;
        }

        public final void setReverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        @Override
        public final Builder reverseOrder(Boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAppAssessmentsRequest build() {
            return new ListAppAssessmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
