/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDraftAppVersionTemplateRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<PutDraftAppVersionTemplateRequest.Builder, PutDraftAppVersionTemplateRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(PutDraftAppVersionTemplateRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> APP_TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appTemplateBody").getter(getter(PutDraftAppVersionTemplateRequest::appTemplateBody))
            .setter(setter(Builder::appTemplateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appTemplateBody").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            APP_TEMPLATE_BODY_FIELD));

    private final String appArn;

    private final String appTemplateBody;

    private PutDraftAppVersionTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appTemplateBody = builder.appTemplateBody;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * A JSON string that provides information about your application structure. To learn more about the
     * <code>appTemplateBody</code> template, see the sample template provided in the <i>Examples</i> section.
     * </p>
     * <p>
     * The <code>appTemplateBody</code> JSON string has the following structure:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>resources</code> </b>
     * </p>
     * <p>
     * The list of logical resources that needs to be included in the application.
     * </p>
     * <p>
     * Type: Array
     * </p>
     * <note>
     * <p>
     * Don't add the resources that you want to exclude.
     * </p>
     * </note>
     * <p>
     * Each <code>resources</code> array item includes the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i> <code>logicalResourceId</code> </i>
     * </p>
     * <p>
     * The logical identifier of the resource.
     * </p>
     * <p>
     * Type: Object
     * </p>
     * <p>
     * Each <code>logicalResourceId</code> object includes the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>identifier</code>
     * </p>
     * <p>
     * The identifier of the resource.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logicalStackName</code>
     * </p>
     * <p>
     * The name of the CloudFormation stack this resource belongs to.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resourceGroupName</code>
     * </p>
     * <p>
     * The name of the resource group this resource belongs to.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terraformSourceName</code>
     * </p>
     * <p>
     * The name of the Terraform S3 state file this resource belongs to.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i> <code>type</code> </i>
     * </p>
     * <p>
     * The type of resource.
     * </p>
     * <p>
     * Type: string
     * </p>
     * </li>
     * <li>
     * <p>
     * <i> <code>name</code> </i>
     * </p>
     * <p>
     * The name of the resource.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>appComponents</code> </b>
     * </p>
     * <p>
     * The list of Application Components that this resource belongs to. If an Application Component is not part of the
     * AWS Resilience Hub application, it will be added.
     * </p>
     * <p>
     * Type: Array
     * </p>
     * <p>
     * Each <code>appComponents</code> array item includes the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>name</code>
     * </p>
     * <p>
     * The name of the Application Component.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code>
     * </p>
     * <p>
     * The type of Application Component. For more information about the types of Application Component, see <a
     * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping resources
     * in an AppComponent</a>.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resourceNames</code>
     * </p>
     * <p>
     * The list of included resources that are assigned to the Application Component.
     * </p>
     * <p>
     * Type: Array of strings
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>additionalInfo</code>
     * </p>
     * <p>
     * Additional configuration parameters for an AWS Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one
     * associated account.
     * </p>
     * <p>
     * Key: <code>"failover-regions"</code>
     * </p>
     * <p>
     * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
     * </p>
     * </note></li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <b> <code>excludedResources</code> </b>
     * </p>
     * <p>
     * The list of logical resource identifiers to be excluded from the application.
     * </p>
     * <p>
     * Type: Array
     * </p>
     * <note>
     * <p>
     * Don't add the resources that you want to include.
     * </p>
     * </note>
     * <p>
     * Each <code>excludedResources</code> array item includes the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i> <code>logicalResourceIds</code> </i>
     * </p>
     * <p>
     * The logical identifier of the resource.
     * </p>
     * <p>
     * Type: Object
     * </p>
     * <note>
     * <p>
     * You can configure only one of the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>logicalStackName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resourceGroupName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terraformSourceName</code>
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * Each <code>logicalResourceIds</code> object includes the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>identifier</code>
     * </p>
     * <p>
     * The identifier of the resource.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>logicalStackName</code>
     * </p>
     * <p>
     * The name of the CloudFormation stack this resource belongs to.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resourceGroupName</code>
     * </p>
     * <p>
     * The name of the resource group this resource belongs to.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terraformSourceName</code>
     * </p>
     * <p>
     * The name of the Terraform S3 state file this resource belongs to.
     * </p>
     * <p>
     * Type: String
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return A JSON string that provides information about your application structure. To learn more about the
     *         <code>appTemplateBody</code> template, see the sample template provided in the <i>Examples</i>
     *         section.</p>
     *         <p>
     *         The <code>appTemplateBody</code> JSON string has the following structure:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>resources</code> </b>
     *         </p>
     *         <p>
     *         The list of logical resources that needs to be included in the application.
     *         </p>
     *         <p>
     *         Type: Array
     *         </p>
     *         <note>
     *         <p>
     *         Don't add the resources that you want to exclude.
     *         </p>
     *         </note>
     *         <p>
     *         Each <code>resources</code> array item includes the following fields:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i> <code>logicalResourceId</code> </i>
     *         </p>
     *         <p>
     *         The logical identifier of the resource.
     *         </p>
     *         <p>
     *         Type: Object
     *         </p>
     *         <p>
     *         Each <code>logicalResourceId</code> object includes the following fields:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>identifier</code>
     *         </p>
     *         <p>
     *         The identifier of the resource.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logicalStackName</code>
     *         </p>
     *         <p>
     *         The name of the CloudFormation stack this resource belongs to.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resourceGroupName</code>
     *         </p>
     *         <p>
     *         The name of the resource group this resource belongs to.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terraformSourceName</code>
     *         </p>
     *         <p>
     *         The name of the Terraform S3 state file this resource belongs to.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i> <code>type</code> </i>
     *         </p>
     *         <p>
     *         The type of resource.
     *         </p>
     *         <p>
     *         Type: string
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i> <code>name</code> </i>
     *         </p>
     *         <p>
     *         The name of the resource.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>appComponents</code> </b>
     *         </p>
     *         <p>
     *         The list of Application Components that this resource belongs to. If an Application Component is not part
     *         of the AWS Resilience Hub application, it will be added.
     *         </p>
     *         <p>
     *         Type: Array
     *         </p>
     *         <p>
     *         Each <code>appComponents</code> array item includes the following fields:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>name</code>
     *         </p>
     *         <p>
     *         The name of the Application Component.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code>
     *         </p>
     *         <p>
     *         The type of Application Component. For more information about the types of Application Component, see <a
     *         href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping
     *         resources in an AppComponent</a>.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resourceNames</code>
     *         </p>
     *         <p>
     *         The list of included resources that are assigned to the Application Component.
     *         </p>
     *         <p>
     *         Type: Array of strings
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>additionalInfo</code>
     *         </p>
     *         <p>
     *         Additional configuration parameters for an AWS Resilience Hub application.
     *         </p>
     *         <note>
     *         <p>
     *         Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region
     *         and one associated account.
     *         </p>
     *         <p>
     *         Key: <code>"failover-regions"</code>
     *         </p>
     *         <p>
     *         Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>excludedResources</code> </b>
     *         </p>
     *         <p>
     *         The list of logical resource identifiers to be excluded from the application.
     *         </p>
     *         <p>
     *         Type: Array
     *         </p>
     *         <note>
     *         <p>
     *         Don't add the resources that you want to include.
     *         </p>
     *         </note>
     *         <p>
     *         Each <code>excludedResources</code> array item includes the following fields:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i> <code>logicalResourceIds</code> </i>
     *         </p>
     *         <p>
     *         The logical identifier of the resource.
     *         </p>
     *         <p>
     *         Type: Object
     *         </p>
     *         <note>
     *         <p>
     *         You can configure only one of the following fields:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>logicalStackName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resourceGroupName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terraformSourceName</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </note>
     *         <p>
     *         Each <code>logicalResourceIds</code> object includes the following fields:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>identifier</code>
     *         </p>
     *         <p>
     *         The identifier of the resource.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>logicalStackName</code>
     *         </p>
     *         <p>
     *         The name of the CloudFormation stack this resource belongs to.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resourceGroupName</code>
     *         </p>
     *         <p>
     *         The name of the resource group this resource belongs to.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terraformSourceName</code>
     *         </p>
     *         <p>
     *         The name of the Terraform S3 state file this resource belongs to.
     *         </p>
     *         <p>
     *         Type: String
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String appTemplateBody() {
        return appTemplateBody;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(appTemplateBody());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDraftAppVersionTemplateRequest)) {
            return false;
        }
        PutDraftAppVersionTemplateRequest other = (PutDraftAppVersionTemplateRequest) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(appTemplateBody(), other.appTemplateBody());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDraftAppVersionTemplateRequest").add("AppArn", appArn())
                .add("AppTemplateBody", appTemplateBody()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "appTemplateBody":
            return Optional.ofNullable(clazz.cast(appTemplateBody()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDraftAppVersionTemplateRequest, T> g) {
        return obj -> g.apply((PutDraftAppVersionTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDraftAppVersionTemplateRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * A JSON string that provides information about your application structure. To learn more about the
         * <code>appTemplateBody</code> template, see the sample template provided in the <i>Examples</i> section.
         * </p>
         * <p>
         * The <code>appTemplateBody</code> JSON string has the following structure:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>resources</code> </b>
         * </p>
         * <p>
         * The list of logical resources that needs to be included in the application.
         * </p>
         * <p>
         * Type: Array
         * </p>
         * <note>
         * <p>
         * Don't add the resources that you want to exclude.
         * </p>
         * </note>
         * <p>
         * Each <code>resources</code> array item includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i> <code>logicalResourceId</code> </i>
         * </p>
         * <p>
         * The logical identifier of the resource.
         * </p>
         * <p>
         * Type: Object
         * </p>
         * <p>
         * Each <code>logicalResourceId</code> object includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>identifier</code>
         * </p>
         * <p>
         * The identifier of the resource.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logicalStackName</code>
         * </p>
         * <p>
         * The name of the CloudFormation stack this resource belongs to.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceGroupName</code>
         * </p>
         * <p>
         * The name of the resource group this resource belongs to.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terraformSourceName</code>
         * </p>
         * <p>
         * The name of the Terraform S3 state file this resource belongs to.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i> <code>type</code> </i>
         * </p>
         * <p>
         * The type of resource.
         * </p>
         * <p>
         * Type: string
         * </p>
         * </li>
         * <li>
         * <p>
         * <i> <code>name</code> </i>
         * </p>
         * <p>
         * The name of the resource.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>appComponents</code> </b>
         * </p>
         * <p>
         * The list of Application Components that this resource belongs to. If an Application Component is not part of
         * the AWS Resilience Hub application, it will be added.
         * </p>
         * <p>
         * Type: Array
         * </p>
         * <p>
         * Each <code>appComponents</code> array item includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>name</code>
         * </p>
         * <p>
         * The name of the Application Component.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code>
         * </p>
         * <p>
         * The type of Application Component. For more information about the types of Application Component, see <a
         * href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">Grouping
         * resources in an AppComponent</a>.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceNames</code>
         * </p>
         * <p>
         * The list of included resources that are assigned to the Application Component.
         * </p>
         * <p>
         * Type: Array of strings
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>additionalInfo</code>
         * </p>
         * <p>
         * Additional configuration parameters for an AWS Resilience Hub application.
         * </p>
         * <note>
         * <p>
         * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and
         * one associated account.
         * </p>
         * <p>
         * Key: <code>"failover-regions"</code>
         * </p>
         * <p>
         * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         * </p>
         * </note></li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <b> <code>excludedResources</code> </b>
         * </p>
         * <p>
         * The list of logical resource identifiers to be excluded from the application.
         * </p>
         * <p>
         * Type: Array
         * </p>
         * <note>
         * <p>
         * Don't add the resources that you want to include.
         * </p>
         * </note>
         * <p>
         * Each <code>excludedResources</code> array item includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i> <code>logicalResourceIds</code> </i>
         * </p>
         * <p>
         * The logical identifier of the resource.
         * </p>
         * <p>
         * Type: Object
         * </p>
         * <note>
         * <p>
         * You can configure only one of the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>logicalStackName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceGroupName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terraformSourceName</code>
         * </p>
         * </li>
         * </ul>
         * </note>
         * <p>
         * Each <code>logicalResourceIds</code> object includes the following fields:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>identifier</code>
         * </p>
         * <p>
         * The identifier of the resource.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>logicalStackName</code>
         * </p>
         * <p>
         * The name of the CloudFormation stack this resource belongs to.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resourceGroupName</code>
         * </p>
         * <p>
         * The name of the resource group this resource belongs to.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terraformSourceName</code>
         * </p>
         * <p>
         * The name of the Terraform S3 state file this resource belongs to.
         * </p>
         * <p>
         * Type: String
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param appTemplateBody
         *        A JSON string that provides information about your application structure. To learn more about the
         *        <code>appTemplateBody</code> template, see the sample template provided in the <i>Examples</i>
         *        section.</p>
         *        <p>
         *        The <code>appTemplateBody</code> JSON string has the following structure:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>resources</code> </b>
         *        </p>
         *        <p>
         *        The list of logical resources that needs to be included in the application.
         *        </p>
         *        <p>
         *        Type: Array
         *        </p>
         *        <note>
         *        <p>
         *        Don't add the resources that you want to exclude.
         *        </p>
         *        </note>
         *        <p>
         *        Each <code>resources</code> array item includes the following fields:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i> <code>logicalResourceId</code> </i>
         *        </p>
         *        <p>
         *        The logical identifier of the resource.
         *        </p>
         *        <p>
         *        Type: Object
         *        </p>
         *        <p>
         *        Each <code>logicalResourceId</code> object includes the following fields:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>identifier</code>
         *        </p>
         *        <p>
         *        The identifier of the resource.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logicalStackName</code>
         *        </p>
         *        <p>
         *        The name of the CloudFormation stack this resource belongs to.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceGroupName</code>
         *        </p>
         *        <p>
         *        The name of the resource group this resource belongs to.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terraformSourceName</code>
         *        </p>
         *        <p>
         *        The name of the Terraform S3 state file this resource belongs to.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i> <code>type</code> </i>
         *        </p>
         *        <p>
         *        The type of resource.
         *        </p>
         *        <p>
         *        Type: string
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i> <code>name</code> </i>
         *        </p>
         *        <p>
         *        The name of the resource.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>appComponents</code> </b>
         *        </p>
         *        <p>
         *        The list of Application Components that this resource belongs to. If an Application Component is not
         *        part of the AWS Resilience Hub application, it will be added.
         *        </p>
         *        <p>
         *        Type: Array
         *        </p>
         *        <p>
         *        Each <code>appComponents</code> array item includes the following fields:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>name</code>
         *        </p>
         *        <p>
         *        The name of the Application Component.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code>
         *        </p>
         *        <p>
         *        The type of Application Component. For more information about the types of Application Component, see
         *        <a href="https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html">
         *        Grouping resources in an AppComponent</a>.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceNames</code>
         *        </p>
         *        <p>
         *        The list of included resources that are assigned to the Application Component.
         *        </p>
         *        <p>
         *        Type: Array of strings
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>additionalInfo</code>
         *        </p>
         *        <p>
         *        Additional configuration parameters for an AWS Resilience Hub application.
         *        </p>
         *        <note>
         *        <p>
         *        Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region
         *        and one associated account.
         *        </p>
         *        <p>
         *        Key: <code>"failover-regions"</code>
         *        </p>
         *        <p>
         *        Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         *        </p>
         *        </note></li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>excludedResources</code> </b>
         *        </p>
         *        <p>
         *        The list of logical resource identifiers to be excluded from the application.
         *        </p>
         *        <p>
         *        Type: Array
         *        </p>
         *        <note>
         *        <p>
         *        Don't add the resources that you want to include.
         *        </p>
         *        </note>
         *        <p>
         *        Each <code>excludedResources</code> array item includes the following fields:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i> <code>logicalResourceIds</code> </i>
         *        </p>
         *        <p>
         *        The logical identifier of the resource.
         *        </p>
         *        <p>
         *        Type: Object
         *        </p>
         *        <note>
         *        <p>
         *        You can configure only one of the following fields:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>logicalStackName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceGroupName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terraformSourceName</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </note>
         *        <p>
         *        Each <code>logicalResourceIds</code> object includes the following fields:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>identifier</code>
         *        </p>
         *        <p>
         *        The identifier of the resource.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>logicalStackName</code>
         *        </p>
         *        <p>
         *        The name of the CloudFormation stack this resource belongs to.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resourceGroupName</code>
         *        </p>
         *        <p>
         *        The name of the resource group this resource belongs to.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terraformSourceName</code>
         *        </p>
         *        <p>
         *        The name of the Terraform S3 state file this resource belongs to.
         *        </p>
         *        <p>
         *        Type: String
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appTemplateBody(String appTemplateBody);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private String appTemplateBody;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDraftAppVersionTemplateRequest model) {
            super(model);
            appArn(model.appArn);
            appTemplateBody(model.appTemplateBody);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppTemplateBody() {
            return appTemplateBody;
        }

        public final void setAppTemplateBody(String appTemplateBody) {
            this.appTemplateBody = appTemplateBody;
        }

        @Override
        public final Builder appTemplateBody(String appTemplateBody) {
            this.appTemplateBody = appTemplateBody;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDraftAppVersionTemplateRequest build() {
            return new PutDraftAppVersionTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
