/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAppInputSourceRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<DeleteAppInputSourceRequest.Builder, DeleteAppInputSourceRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(DeleteAppInputSourceRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteAppInputSourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceArn").getter(getter(DeleteAppInputSourceRequest::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()).build();

    private static final SdkField<TerraformSource> TERRAFORM_SOURCE_FIELD = SdkField
            .<TerraformSource> builder(MarshallingType.SDK_POJO).memberName("terraformSource")
            .getter(getter(DeleteAppInputSourceRequest::terraformSource)).setter(setter(Builder::terraformSource))
            .constructor(TerraformSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            CLIENT_TOKEN_FIELD, SOURCE_ARN_FIELD, TERRAFORM_SOURCE_FIELD));

    private final String appArn;

    private final String clientToken;

    private final String sourceArn;

    private final TerraformSource terraformSource;

    private DeleteAppInputSourceRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.clientToken = builder.clientToken;
        this.sourceArn = builder.sourceArn;
        this.terraformSource = builder.terraformSource;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
     * You should not reuse the same client token for other API requests.
     * </p>
     * 
     * @return Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
     *         characters. You should not reuse the same client token for other API requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the imported resource you want to remove from the AWS Resilience Hub
     * application. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the imported resource you want to remove from the AWS Resilience Hub
     *         application. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The imported Terraform s3 state ﬁle you want to remove from the AWS Resilience Hub application.
     * </p>
     * 
     * @return The imported Terraform s3 state ﬁle you want to remove from the AWS Resilience Hub application.
     */
    public final TerraformSource terraformSource() {
        return terraformSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(terraformSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppInputSourceRequest)) {
            return false;
        }
        DeleteAppInputSourceRequest other = (DeleteAppInputSourceRequest) obj;
        return Objects.equals(appArn(), other.appArn()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(terraformSource(), other.terraformSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAppInputSourceRequest").add("AppArn", appArn()).add("ClientToken", clientToken())
                .add("SourceArn", sourceArn()).add("TerraformSource", terraformSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "sourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "terraformSource":
            return Optional.ofNullable(clazz.cast(terraformSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAppInputSourceRequest, T> g) {
        return obj -> g.apply((DeleteAppInputSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAppInputSourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the AWS Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         * characters. You should not reuse the same client token for other API requests.
         * </p>
         * 
         * @param clientToken
         *        Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         *        characters. You should not reuse the same client token for other API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the imported resource you want to remove from the AWS Resilience Hub
         * application. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the imported resource you want to remove from the AWS Resilience Hub
         *        application. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The imported Terraform s3 state ﬁle you want to remove from the AWS Resilience Hub application.
         * </p>
         * 
         * @param terraformSource
         *        The imported Terraform s3 state ﬁle you want to remove from the AWS Resilience Hub application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSource(TerraformSource terraformSource);

        /**
         * <p>
         * The imported Terraform s3 state ﬁle you want to remove from the AWS Resilience Hub application.
         * </p>
         * This is a convenience method that creates an instance of the {@link TerraformSource.Builder} avoiding the
         * need to create one manually via {@link TerraformSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TerraformSource.Builder#build()} is called immediately and its
         * result is passed to {@link #terraformSource(TerraformSource)}.
         * 
         * @param terraformSource
         *        a consumer that will call methods on {@link TerraformSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terraformSource(TerraformSource)
         */
        default Builder terraformSource(Consumer<TerraformSource.Builder> terraformSource) {
            return terraformSource(TerraformSource.builder().applyMutation(terraformSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private String clientToken;

        private String sourceArn;

        private TerraformSource terraformSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppInputSourceRequest model) {
            super(model);
            appArn(model.appArn);
            clientToken(model.clientToken);
            sourceArn(model.sourceArn);
            terraformSource(model.terraformSource);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final TerraformSource.Builder getTerraformSource() {
            return terraformSource != null ? terraformSource.toBuilder() : null;
        }

        public final void setTerraformSource(TerraformSource.BuilderImpl terraformSource) {
            this.terraformSource = terraformSource != null ? terraformSource.build() : null;
        }

        @Override
        public final Builder terraformSource(TerraformSource terraformSource) {
            this.terraformSource = terraformSource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAppInputSourceRequest build() {
            return new DeleteAppInputSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
