/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified
 * using an Amazon Resource Name (ARN) or an AWS Resilience Hub-native identifier.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhysicalResource implements SdkPojo, Serializable,
        ToCopyableBuilder<PhysicalResource.Builder, PhysicalResource> {
    private static final SdkField<Map<String, List<String>>> ADDITIONAL_INFO_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("additionalInfo")
            .getter(getter(PhysicalResource::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInfo").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<AppComponent>> APP_COMPONENTS_FIELD = SdkField
            .<List<AppComponent>> builder(MarshallingType.LIST)
            .memberName("appComponents")
            .getter(getter(PhysicalResource::appComponents))
            .setter(setter(Builder::appComponents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppComponent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppComponent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excluded").getter(getter(PhysicalResource::excluded)).setter(setter(Builder::excluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()).build();

    private static final SdkField<LogicalResourceId> LOGICAL_RESOURCE_ID_FIELD = SdkField
            .<LogicalResourceId> builder(MarshallingType.SDK_POJO).memberName("logicalResourceId")
            .getter(getter(PhysicalResource::logicalResourceId)).setter(setter(Builder::logicalResourceId))
            .constructor(LogicalResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalResourceId").build()).build();

    private static final SdkField<PhysicalResourceId> PHYSICAL_RESOURCE_ID_FIELD = SdkField
            .<PhysicalResourceId> builder(MarshallingType.SDK_POJO).memberName("physicalResourceId")
            .getter(getter(PhysicalResource::physicalResourceId)).setter(setter(Builder::physicalResourceId))
            .constructor(PhysicalResourceId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResourceId").build())
            .build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceName").getter(getter(PhysicalResource::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(PhysicalResource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_INFO_FIELD,
            APP_COMPONENTS_FIELD, EXCLUDED_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_NAME_FIELD,
            RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, List<String>> additionalInfo;

    private final List<AppComponent> appComponents;

    private final Boolean excluded;

    private final LogicalResourceId logicalResourceId;

    private final PhysicalResourceId physicalResourceId;

    private final String resourceName;

    private final String resourceType;

    private PhysicalResource(BuilderImpl builder) {
        this.additionalInfo = builder.additionalInfo;
        this.appComponents = builder.appComponents;
        this.excluded = builder.excluded;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalInfo() {
        return additionalInfo != null && !(additionalInfo instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional configuration parameters for an AWS Resilience Hub application.
     * </p>
     * <note>
     * <p>
     * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one
     * associated account.
     * </p>
     * <p>
     * Key: <code>"failover-regions"</code>
     * </p>
     * <p>
     * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalInfo} method.
     * </p>
     * 
     * @return Additional configuration parameters for an AWS Resilience Hub application.</p> <note>
     *         <p>
     *         Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region
     *         and one associated account.
     *         </p>
     *         <p>
     *         Key: <code>"failover-regions"</code>
     *         </p>
     *         <p>
     *         Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
     *         </p>
     */
    public final Map<String, List<String>> additionalInfo() {
        return additionalInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppComponents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppComponents() {
        return appComponents != null && !(appComponents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The application components that belong to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppComponents} method.
     * </p>
     * 
     * @return The application components that belong to this resource.
     */
    public final List<AppComponent> appComponents() {
        return appComponents;
    }

    /**
     * <p>
     * Indicates if a resource is included or excluded from the assessment.
     * </p>
     * 
     * @return Indicates if a resource is included or excluded from the assessment.
     */
    public final Boolean excluded() {
        return excluded;
    }

    /**
     * <p>
     * The logical identifier of the resource.
     * </p>
     * 
     * @return The logical identifier of the resource.
     */
    public final LogicalResourceId logicalResourceId() {
        return logicalResourceId;
    }

    /**
     * <p>
     * The physical identifier of the resource.
     * </p>
     * 
     * @return The physical identifier of the resource.
     */
    public final PhysicalResourceId physicalResourceId() {
        return physicalResourceId;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The type of resource.
     * </p>
     * 
     * @return The type of resource.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalInfo() ? additionalInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAppComponents() ? appComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(excluded());
        hashCode = 31 * hashCode + Objects.hashCode(logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhysicalResource)) {
            return false;
        }
        PhysicalResource other = (PhysicalResource) obj;
        return hasAdditionalInfo() == other.hasAdditionalInfo() && Objects.equals(additionalInfo(), other.additionalInfo())
                && hasAppComponents() == other.hasAppComponents() && Objects.equals(appComponents(), other.appComponents())
                && Objects.equals(excluded(), other.excluded()) && Objects.equals(logicalResourceId(), other.logicalResourceId())
                && Objects.equals(physicalResourceId(), other.physicalResourceId())
                && Objects.equals(resourceName(), other.resourceName()) && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PhysicalResource").add("AdditionalInfo", hasAdditionalInfo() ? additionalInfo() : null)
                .add("AppComponents", hasAppComponents() ? appComponents() : null).add("Excluded", excluded())
                .add("LogicalResourceId", logicalResourceId()).add("PhysicalResourceId", physicalResourceId())
                .add("ResourceName", resourceName()).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        case "appComponents":
            return Optional.ofNullable(clazz.cast(appComponents()));
        case "excluded":
            return Optional.ofNullable(clazz.cast(excluded()));
        case "logicalResourceId":
            return Optional.ofNullable(clazz.cast(logicalResourceId()));
        case "physicalResourceId":
            return Optional.ofNullable(clazz.cast(physicalResourceId()));
        case "resourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhysicalResource, T> g) {
        return obj -> g.apply((PhysicalResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhysicalResource> {
        /**
         * <p>
         * Additional configuration parameters for an AWS Resilience Hub application.
         * </p>
         * <note>
         * <p>
         * Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and
         * one associated account.
         * </p>
         * <p>
         * Key: <code>"failover-regions"</code>
         * </p>
         * <p>
         * Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         * </p>
         * </note>
         * 
         * @param additionalInfo
         *        Additional configuration parameters for an AWS Resilience Hub application.</p> <note>
         *        <p>
         *        Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region
         *        and one associated account.
         *        </p>
         *        <p>
         *        Key: <code>"failover-regions"</code>
         *        </p>
         *        <p>
         *        Value: <code>"[{"region":"&lt;REGION&gt;", "accounts":[{"id":"&lt;ACCOUNT_ID&gt;"}]}]"</code>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo);

        /**
         * <p>
         * The application components that belong to this resource.
         * </p>
         * 
         * @param appComponents
         *        The application components that belong to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponents(Collection<AppComponent> appComponents);

        /**
         * <p>
         * The application components that belong to this resource.
         * </p>
         * 
         * @param appComponents
         *        The application components that belong to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponents(AppComponent... appComponents);

        /**
         * <p>
         * The application components that belong to this resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent.Builder#build()} is called
         * immediately and its result is passed to {@link #appComponents(List<AppComponent>)}.
         * 
         * @param appComponents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.AppComponent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appComponents(java.util.Collection<AppComponent>)
         */
        Builder appComponents(Consumer<AppComponent.Builder>... appComponents);

        /**
         * <p>
         * Indicates if a resource is included or excluded from the assessment.
         * </p>
         * 
         * @param excluded
         *        Indicates if a resource is included or excluded from the assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excluded(Boolean excluded);

        /**
         * <p>
         * The logical identifier of the resource.
         * </p>
         * 
         * @param logicalResourceId
         *        The logical identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalResourceId(LogicalResourceId logicalResourceId);

        /**
         * <p>
         * The logical identifier of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogicalResourceId.Builder} avoiding the
         * need to create one manually via {@link LogicalResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogicalResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #logicalResourceId(LogicalResourceId)}.
         * 
         * @param logicalResourceId
         *        a consumer that will call methods on {@link LogicalResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicalResourceId(LogicalResourceId)
         */
        default Builder logicalResourceId(Consumer<LogicalResourceId.Builder> logicalResourceId) {
            return logicalResourceId(LogicalResourceId.builder().applyMutation(logicalResourceId).build());
        }

        /**
         * <p>
         * The physical identifier of the resource.
         * </p>
         * 
         * @param physicalResourceId
         *        The physical identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalResourceId(PhysicalResourceId physicalResourceId);

        /**
         * <p>
         * The physical identifier of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link PhysicalResourceId.Builder} avoiding the
         * need to create one manually via {@link PhysicalResourceId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PhysicalResourceId.Builder#build()} is called immediately and its
         * result is passed to {@link #physicalResourceId(PhysicalResourceId)}.
         * 
         * @param physicalResourceId
         *        a consumer that will call methods on {@link PhysicalResourceId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #physicalResourceId(PhysicalResourceId)
         */
        default Builder physicalResourceId(Consumer<PhysicalResourceId.Builder> physicalResourceId) {
            return physicalResourceId(PhysicalResourceId.builder().applyMutation(physicalResourceId).build());
        }

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param resourceName
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The type of resource.
         * </p>
         * 
         * @param resourceType
         *        The type of resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, List<String>> additionalInfo = DefaultSdkAutoConstructMap.getInstance();

        private List<AppComponent> appComponents = DefaultSdkAutoConstructList.getInstance();

        private Boolean excluded;

        private LogicalResourceId logicalResourceId;

        private PhysicalResourceId physicalResourceId;

        private String resourceName;

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(PhysicalResource model) {
            additionalInfo(model.additionalInfo);
            appComponents(model.appComponents);
            excluded(model.excluded);
            logicalResourceId(model.logicalResourceId);
            physicalResourceId(model.physicalResourceId);
            resourceName(model.resourceName);
            resourceType(model.resourceType);
        }

        public final Map<String, ? extends Collection<String>> getAdditionalInfo() {
            if (additionalInfo instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalInfo;
        }

        public final void setAdditionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
        }

        @Override
        public final Builder additionalInfo(Map<String, ? extends Collection<String>> additionalInfo) {
            this.additionalInfo = AdditionalInfoMapCopier.copy(additionalInfo);
            return this;
        }

        public final List<AppComponent.Builder> getAppComponents() {
            List<AppComponent.Builder> result = AppComponentListCopier.copyToBuilder(this.appComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppComponents(Collection<AppComponent.BuilderImpl> appComponents) {
            this.appComponents = AppComponentListCopier.copyFromBuilder(appComponents);
        }

        @Override
        public final Builder appComponents(Collection<AppComponent> appComponents) {
            this.appComponents = AppComponentListCopier.copy(appComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(AppComponent... appComponents) {
            appComponents(Arrays.asList(appComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appComponents(Consumer<AppComponent.Builder>... appComponents) {
            appComponents(Stream.of(appComponents).map(c -> AppComponent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getExcluded() {
            return excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final LogicalResourceId.Builder getLogicalResourceId() {
            return logicalResourceId != null ? logicalResourceId.toBuilder() : null;
        }

        public final void setLogicalResourceId(LogicalResourceId.BuilderImpl logicalResourceId) {
            this.logicalResourceId = logicalResourceId != null ? logicalResourceId.build() : null;
        }

        @Override
        public final Builder logicalResourceId(LogicalResourceId logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final PhysicalResourceId.Builder getPhysicalResourceId() {
            return physicalResourceId != null ? physicalResourceId.toBuilder() : null;
        }

        public final void setPhysicalResourceId(PhysicalResourceId.BuilderImpl physicalResourceId) {
            this.physicalResourceId = physicalResourceId != null ? physicalResourceId.build() : null;
        }

        @Override
        public final Builder physicalResourceId(PhysicalResourceId physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public PhysicalResource build() {
            return new PhysicalResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
