/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesResponse;

public class ListAppInputSourcesIterable
implements SdkIterable<ListAppInputSourcesResponse> {
    private final ResiliencehubClient client;
    private final ListAppInputSourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppInputSourcesIterable(ResiliencehubClient client, ListAppInputSourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppInputSourcesResponseFetcher();
    }

    public Iterator<ListAppInputSourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppInputSourcesResponseFetcher
    implements SyncPageFetcher<ListAppInputSourcesResponse> {
        private ListAppInputSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInputSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppInputSourcesResponse nextPage(ListAppInputSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAppInputSourcesIterable.this.client.listAppInputSources(ListAppInputSourcesIterable.this.firstRequest);
            }
            return ListAppInputSourcesIterable.this.client.listAppInputSources((ListAppInputSourcesRequest)((Object)ListAppInputSourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

