/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an Resilience Hub application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class App implements SdkPojo, Serializable, ToCopyableBuilder<App.Builder, App> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(App::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<String> ASSESSMENT_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentSchedule").getter(getter(App::assessmentScheduleAsString))
            .setter(setter(Builder::assessmentSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSchedule").build())
            .build();

    private static final SdkField<String> COMPLIANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("complianceStatus").getter(getter(App::complianceStatusAsString))
            .setter(setter(Builder::complianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("complianceStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(App::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(App::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastAppComplianceEvaluationTime")
            .getter(getter(App::lastAppComplianceEvaluationTime))
            .setter(setter(Builder::lastAppComplianceEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastAppComplianceEvaluationTime")
                    .build()).build();

    private static final SdkField<Instant> LAST_RESILIENCY_SCORE_EVALUATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastResiliencyScoreEvaluationTime")
            .getter(getter(App::lastResiliencyScoreEvaluationTime))
            .setter(setter(Builder::lastResiliencyScoreEvaluationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastResiliencyScoreEvaluationTime")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(App::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(App::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<Double> RESILIENCY_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("resiliencyScore").getter(getter(App::resiliencyScore)).setter(setter(Builder::resiliencyScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(App::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(App::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            ASSESSMENT_SCHEDULE_FIELD, COMPLIANCE_STATUS_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD,
            LAST_APP_COMPLIANCE_EVALUATION_TIME_FIELD, LAST_RESILIENCY_SCORE_EVALUATION_TIME_FIELD, NAME_FIELD, POLICY_ARN_FIELD,
            RESILIENCY_SCORE_FIELD, STATUS_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appArn;

    private final String assessmentSchedule;

    private final String complianceStatus;

    private final Instant creationTime;

    private final String description;

    private final Instant lastAppComplianceEvaluationTime;

    private final Instant lastResiliencyScoreEvaluationTime;

    private final String name;

    private final String policyArn;

    private final Double resiliencyScore;

    private final String status;

    private final Map<String, String> tags;

    private App(BuilderImpl builder) {
        this.appArn = builder.appArn;
        this.assessmentSchedule = builder.assessmentSchedule;
        this.complianceStatus = builder.complianceStatus;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.lastAppComplianceEvaluationTime = builder.lastAppComplianceEvaluationTime;
        this.lastResiliencyScoreEvaluationTime = builder.lastResiliencyScoreEvaluationTime;
        this.name = builder.name;
        this.policyArn = builder.policyArn;
        this.resiliencyScore = builder.resiliencyScore;
        this.status = builder.status;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final AppAssessmentScheduleType assessmentSchedule() {
        return AppAssessmentScheduleType.fromValue(assessmentSchedule);
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final String assessmentScheduleAsString() {
        return assessmentSchedule;
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link AppComplianceStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see AppComplianceStatusType
     */
    public final AppComplianceStatusType complianceStatus() {
        return AppComplianceStatusType.fromValue(complianceStatus);
    }

    /**
     * <p>
     * The current status of compliance for the resiliency policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #complianceStatus}
     * will return {@link AppComplianceStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #complianceStatusAsString}.
     * </p>
     * 
     * @return The current status of compliance for the resiliency policy.
     * @see AppComplianceStatusType
     */
    public final String complianceStatusAsString() {
        return complianceStatus;
    }

    /**
     * <p>
     * The timestamp for when the app was created.
     * </p>
     * 
     * @return The timestamp for when the app was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The optional description for an app.
     * </p>
     * 
     * @return The optional description for an app.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp for the most recent compliance evaluation.
     * </p>
     * 
     * @return The timestamp for the most recent compliance evaluation.
     */
    public final Instant lastAppComplianceEvaluationTime() {
        return lastAppComplianceEvaluationTime;
    }

    /**
     * <p>
     * The timestamp for the most recent resiliency score evaluation.
     * </p>
     * 
     * @return The timestamp for the most recent resiliency score evaluation.
     */
    public final Instant lastResiliencyScoreEvaluationTime() {
        return lastResiliencyScoreEvaluationTime;
    }

    /**
     * <p>
     * The name for the application.
     * </p>
     * 
     * @return The name for the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
     *         <code>policy-id</code>. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i> guide.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The current resiliency score for the application.
     * </p>
     * 
     * @return The current resiliency score for the application.
     */
    public final Double resiliencyScore() {
        return resiliencyScore;
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see AppStatusType
     */
    public final AppStatusType status() {
        return AppStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AppStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the application.
     * @see AppStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key/value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
     *         Each tag consists of a key/value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(complianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastAppComplianceEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastResiliencyScoreEvaluationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App) obj;
        return Objects.equals(appArn(), other.appArn())
                && Objects.equals(assessmentScheduleAsString(), other.assessmentScheduleAsString())
                && Objects.equals(complianceStatusAsString(), other.complianceStatusAsString())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(description(), other.description())
                && Objects.equals(lastAppComplianceEvaluationTime(), other.lastAppComplianceEvaluationTime())
                && Objects.equals(lastResiliencyScoreEvaluationTime(), other.lastResiliencyScoreEvaluationTime())
                && Objects.equals(name(), other.name()) && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(resiliencyScore(), other.resiliencyScore())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("App").add("AppArn", appArn()).add("AssessmentSchedule", assessmentScheduleAsString())
                .add("ComplianceStatus", complianceStatusAsString()).add("CreationTime", creationTime())
                .add("Description", description()).add("LastAppComplianceEvaluationTime", lastAppComplianceEvaluationTime())
                .add("LastResiliencyScoreEvaluationTime", lastResiliencyScoreEvaluationTime()).add("Name", name())
                .add("PolicyArn", policyArn()).add("ResiliencyScore", resiliencyScore()).add("Status", statusAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "assessmentSchedule":
            return Optional.ofNullable(clazz.cast(assessmentScheduleAsString()));
        case "complianceStatus":
            return Optional.ofNullable(clazz.cast(complianceStatusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "lastAppComplianceEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastAppComplianceEvaluationTime()));
        case "lastResiliencyScoreEvaluationTime":
            return Optional.ofNullable(clazz.cast(lastResiliencyScoreEvaluationTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "resiliencyScore":
            return Optional.ofNullable(clazz.cast(resiliencyScore()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, App> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        The Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(String assessmentSchedule);

        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see AppComplianceStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppComplianceStatusType
         */
        Builder complianceStatus(String complianceStatus);

        /**
         * <p>
         * The current status of compliance for the resiliency policy.
         * </p>
         * 
         * @param complianceStatus
         *        The current status of compliance for the resiliency policy.
         * @see AppComplianceStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppComplianceStatusType
         */
        Builder complianceStatus(AppComplianceStatusType complianceStatus);

        /**
         * <p>
         * The timestamp for when the app was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp for when the app was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The optional description for an app.
         * </p>
         * 
         * @param description
         *        The optional description for an app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp for the most recent compliance evaluation.
         * </p>
         * 
         * @param lastAppComplianceEvaluationTime
         *        The timestamp for the most recent compliance evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime);

        /**
         * <p>
         * The timestamp for the most recent resiliency score evaluation.
         * </p>
         * 
         * @param lastResiliencyScoreEvaluationTime
         *        The timestamp for the most recent resiliency score evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime);

        /**
         * <p>
         * The name for the application.
         * </p>
         * 
         * @param name
         *        The name for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
         * <code>policy-id</code>. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
         *        <code>policy-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The current resiliency score for the application.
         * </p>
         * 
         * @param resiliencyScore
         *        The current resiliency score for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resiliencyScore(Double resiliencyScore);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see AppStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the application.
         * </p>
         * 
         * @param status
         *        The status of the application.
         * @see AppStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppStatusType
         */
        Builder status(AppStatusType status);

        /**
         * <p>
         * The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each
         * tag consists of a key/value pair.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services
         *        resource. Each tag consists of a key/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String appArn;

        private String assessmentSchedule;

        private String complianceStatus;

        private Instant creationTime;

        private String description;

        private Instant lastAppComplianceEvaluationTime;

        private Instant lastResiliencyScoreEvaluationTime;

        private String name;

        private String policyArn;

        private Double resiliencyScore;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            appArn(model.appArn);
            assessmentSchedule(model.assessmentSchedule);
            complianceStatus(model.complianceStatus);
            creationTime(model.creationTime);
            description(model.description);
            lastAppComplianceEvaluationTime(model.lastAppComplianceEvaluationTime);
            lastResiliencyScoreEvaluationTime(model.lastResiliencyScoreEvaluationTime);
            name(model.name);
            policyArn(model.policyArn);
            resiliencyScore(model.resiliencyScore);
            status(model.status);
            tags(model.tags);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAssessmentSchedule() {
            return assessmentSchedule;
        }

        public final void setAssessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
        }

        @Override
        public final Builder assessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
            return this;
        }

        @Override
        public final Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
            this.assessmentSchedule(assessmentSchedule == null ? null : assessmentSchedule.toString());
            return this;
        }

        public final String getComplianceStatus() {
            return complianceStatus;
        }

        public final void setComplianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
        }

        @Override
        public final Builder complianceStatus(String complianceStatus) {
            this.complianceStatus = complianceStatus;
            return this;
        }

        @Override
        public final Builder complianceStatus(AppComplianceStatusType complianceStatus) {
            this.complianceStatus(complianceStatus == null ? null : complianceStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastAppComplianceEvaluationTime() {
            return lastAppComplianceEvaluationTime;
        }

        public final void setLastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
        }

        @Override
        public final Builder lastAppComplianceEvaluationTime(Instant lastAppComplianceEvaluationTime) {
            this.lastAppComplianceEvaluationTime = lastAppComplianceEvaluationTime;
            return this;
        }

        public final Instant getLastResiliencyScoreEvaluationTime() {
            return lastResiliencyScoreEvaluationTime;
        }

        public final void setLastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime) {
            this.lastResiliencyScoreEvaluationTime = lastResiliencyScoreEvaluationTime;
        }

        @Override
        public final Builder lastResiliencyScoreEvaluationTime(Instant lastResiliencyScoreEvaluationTime) {
            this.lastResiliencyScoreEvaluationTime = lastResiliencyScoreEvaluationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Double getResiliencyScore() {
            return resiliencyScore;
        }

        public final void setResiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
        }

        @Override
        public final Builder resiliencyScore(Double resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public App build() {
            return new App(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
