/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.AppInputSource;
import software.amazon.awssdk.services.resiliencehub.model.AppInputSourceListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppInputSourcesResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppInputSourcesResponse> {
    private static final SdkField<List<AppInputSource>> APP_INPUT_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appInputSources").getter(ListAppInputSourcesResponse.getter(ListAppInputSourcesResponse::appInputSources)).setter(ListAppInputSourcesResponse.setter(Builder::appInputSources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appInputSources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppInputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppInputSourcesResponse.getter(ListAppInputSourcesResponse::nextToken)).setter(ListAppInputSourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INPUT_SOURCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<AppInputSource> appInputSources;
    private final String nextToken;

    private ListAppInputSourcesResponse(BuilderImpl builder) {
        super(builder);
        this.appInputSources = builder.appInputSources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAppInputSources() {
        return this.appInputSources != null && !(this.appInputSources instanceof SdkAutoConstructList);
    }

    public final List<AppInputSource> appInputSources() {
        return this.appInputSources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppInputSources() ? this.appInputSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInputSourcesResponse)) {
            return false;
        }
        ListAppInputSourcesResponse other = (ListAppInputSourcesResponse)((Object)obj);
        return this.hasAppInputSources() == other.hasAppInputSources() && Objects.equals(this.appInputSources(), other.appInputSources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppInputSourcesResponse").add("AppInputSources", this.hasAppInputSources() ? this.appInputSources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appInputSources": {
                return Optional.ofNullable(clazz.cast(this.appInputSources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppInputSourcesResponse, T> g) {
        return obj -> g.apply((ListAppInputSourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private List<AppInputSource> appInputSources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInputSourcesResponse model) {
            super(model);
            this.appInputSources(model.appInputSources);
            this.nextToken(model.nextToken);
        }

        public final List<AppInputSource.Builder> getAppInputSources() {
            List<AppInputSource.Builder> result = AppInputSourceListCopier.copyToBuilder(this.appInputSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInputSources(Collection<AppInputSource.BuilderImpl> appInputSources) {
            this.appInputSources = AppInputSourceListCopier.copyFromBuilder(appInputSources);
        }

        @Override
        public final Builder appInputSources(Collection<AppInputSource> appInputSources) {
            this.appInputSources = AppInputSourceListCopier.copy(appInputSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInputSources(AppInputSource ... appInputSources) {
            this.appInputSources(Arrays.asList(appInputSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInputSources(Consumer<AppInputSource.Builder> ... appInputSources) {
            this.appInputSources(Stream.of(appInputSources).map(c -> (AppInputSource)((AppInputSource.Builder)AppInputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInputSourcesResponse build() {
            return new ListAppInputSourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppInputSourcesResponse> {
        public Builder appInputSources(Collection<AppInputSource> var1);

        public Builder appInputSources(AppInputSource ... var1);

        public Builder appInputSources(Consumer<AppInputSource.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

