/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CostFrequency {
    HOURLY("Hourly"),
    DAILY("Daily"),
    MONTHLY("Monthly"),
    YEARLY("Yearly"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CostFrequency> VALUE_MAP;
    private final String value;

    private CostFrequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CostFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CostFrequency> knownValues() {
        EnumSet<CostFrequency> knownValues = EnumSet.allOf(CostFrequency.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CostFrequency.class, CostFrequency::toString);
    }
}

