/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListTestRecommendationsResponse;

public class ListTestRecommendationsIterable
implements SdkIterable<ListTestRecommendationsResponse> {
    private final ResiliencehubClient client;
    private final ListTestRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestRecommendationsIterable(ResiliencehubClient client, ListTestRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTestRecommendationsResponseFetcher();
    }

    public Iterator<ListTestRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestRecommendationsResponseFetcher
    implements SyncPageFetcher<ListTestRecommendationsResponse> {
        private ListTestRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestRecommendationsResponse nextPage(ListTestRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListTestRecommendationsIterable.this.client.listTestRecommendations(ListTestRecommendationsIterable.this.firstRequest);
            }
            return ListTestRecommendationsIterable.this.client.listTestRecommendations((ListTestRecommendationsRequest)((Object)ListTestRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

