/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PhysicalIdentifierType {
    ARN("Arn"),
    NATIVE("Native"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PhysicalIdentifierType> VALUE_MAP;
    private final String value;

    private PhysicalIdentifierType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PhysicalIdentifierType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PhysicalIdentifierType> knownValues() {
        EnumSet<PhysicalIdentifierType> knownValues = EnumSet.allOf(PhysicalIdentifierType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PhysicalIdentifierType.class, PhysicalIdentifierType::toString);
    }
}

