/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppInputSourcesResponse;

public class ListAppInputSourcesPublisher
implements SdkPublisher<ListAppInputSourcesResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAppInputSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppInputSourcesPublisher(ResiliencehubAsyncClient client, ListAppInputSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppInputSourcesPublisher(ResiliencehubAsyncClient client, ListAppInputSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppInputSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppInputSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppInputSourcesResponseFetcher
    implements AsyncPageFetcher<ListAppInputSourcesResponse> {
        private ListAppInputSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppInputSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppInputSourcesResponse> nextPage(ListAppInputSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAppInputSourcesPublisher.this.client.listAppInputSources(ListAppInputSourcesPublisher.this.firstRequest);
            }
            return ListAppInputSourcesPublisher.this.client.listAppInputSources((ListAppInputSourcesRequest)((Object)ListAppInputSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

