/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DriftType {
    APPLICATION_COMPLIANCE("ApplicationCompliance"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DriftType> VALUE_MAP;
    private final String value;

    private DriftType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DriftType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DriftType> knownValues() {
        EnumSet<DriftType> knownValues = EnumSet.allOf(DriftType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DriftType.class, DriftType::toString);
    }
}

