/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PermissionModelType {
    LEGACY_IAM_USER("LegacyIAMUser"),
    ROLE_BASED("RoleBased"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PermissionModelType> VALUE_MAP;
    private final String value;

    private PermissionModelType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PermissionModelType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PermissionModelType> knownValues() {
        EnumSet<PermissionModelType> knownValues = EnumSet.allOf(PermissionModelType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PermissionModelType.class, PermissionModelType::toString);
    }
}

