/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateRecommendationStatusRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<BatchUpdateRecommendationStatusRequest.Builder, BatchUpdateRecommendationStatusRequest> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appArn")
            .getter(getter(BatchUpdateRecommendationStatusRequest::appArn)).setter(setter(Builder::appArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()).build();

    private static final SdkField<List<UpdateRecommendationStatusRequestEntry>> REQUEST_ENTRIES_FIELD = SdkField
            .<List<UpdateRecommendationStatusRequestEntry>> builder(MarshallingType.LIST)
            .memberName("requestEntries")
            .getter(getter(BatchUpdateRecommendationStatusRequest::requestEntries))
            .setter(setter(Builder::requestEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateRecommendationStatusRequestEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateRecommendationStatusRequestEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD,
            REQUEST_ENTRIES_FIELD));

    private final String appArn;

    private final List<UpdateRecommendationStatusRequestEntry> requestEntries;

    private BatchUpdateRecommendationStatusRequest(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.requestEntries = builder.requestEntries;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String appArn() {
        return appArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the RequestEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRequestEntries() {
        return requestEntries != null && !(requestEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the list of operational recommendations that need to be included or excluded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRequestEntries} method.
     * </p>
     * 
     * @return Defines the list of operational recommendations that need to be included or excluded.
     */
    public final List<UpdateRecommendationStatusRequestEntry> requestEntries() {
        return requestEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestEntries() ? requestEntries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRecommendationStatusRequest)) {
            return false;
        }
        BatchUpdateRecommendationStatusRequest other = (BatchUpdateRecommendationStatusRequest) obj;
        return Objects.equals(appArn(), other.appArn()) && hasRequestEntries() == other.hasRequestEntries()
                && Objects.equals(requestEntries(), other.requestEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateRecommendationStatusRequest").add("AppArn", appArn())
                .add("RequestEntries", hasRequestEntries() ? requestEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appArn":
            return Optional.ofNullable(clazz.cast(appArn()));
        case "requestEntries":
            return Optional.ofNullable(clazz.cast(requestEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRecommendationStatusRequest, T> g) {
        return obj -> g.apply((BatchUpdateRecommendationStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateRecommendationStatusRequest> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         * <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>. For
         * more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param appArn
         *        Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:app/<code>app-id</code>.
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appArn(String appArn);

        /**
         * <p>
         * Defines the list of operational recommendations that need to be included or excluded.
         * </p>
         * 
         * @param requestEntries
         *        Defines the list of operational recommendations that need to be included or excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestEntries(Collection<UpdateRecommendationStatusRequestEntry> requestEntries);

        /**
         * <p>
         * Defines the list of operational recommendations that need to be included or excluded.
         * </p>
         * 
         * @param requestEntries
         *        Defines the list of operational recommendations that need to be included or excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestEntries(UpdateRecommendationStatusRequestEntry... requestEntries);

        /**
         * <p>
         * Defines the list of operational recommendations that need to be included or excluded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.UpdateRecommendationStatusRequestEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.UpdateRecommendationStatusRequestEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.UpdateRecommendationStatusRequestEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #requestEntries(List<UpdateRecommendationStatusRequestEntry>)}.
         * 
         * @param requestEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.UpdateRecommendationStatusRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestEntries(java.util.Collection<UpdateRecommendationStatusRequestEntry>)
         */
        Builder requestEntries(Consumer<UpdateRecommendationStatusRequestEntry.Builder>... requestEntries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String appArn;

        private List<UpdateRecommendationStatusRequestEntry> requestEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRecommendationStatusRequest model) {
            super(model);
            appArn(model.appArn);
            requestEntries(model.requestEntries);
        }

        public final String getAppArn() {
            return appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final List<UpdateRecommendationStatusRequestEntry.Builder> getRequestEntries() {
            List<UpdateRecommendationStatusRequestEntry.Builder> result = UpdateRecommendationStatusRequestEntriesCopier
                    .copyToBuilder(this.requestEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequestEntries(Collection<UpdateRecommendationStatusRequestEntry.BuilderImpl> requestEntries) {
            this.requestEntries = UpdateRecommendationStatusRequestEntriesCopier.copyFromBuilder(requestEntries);
        }

        @Override
        public final Builder requestEntries(Collection<UpdateRecommendationStatusRequestEntry> requestEntries) {
            this.requestEntries = UpdateRecommendationStatusRequestEntriesCopier.copy(requestEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestEntries(UpdateRecommendationStatusRequestEntry... requestEntries) {
            requestEntries(Arrays.asList(requestEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestEntries(Consumer<UpdateRecommendationStatusRequestEntry.Builder>... requestEntries) {
            requestEntries(Stream.of(requestEntries)
                    .map(c -> UpdateRecommendationStatusRequestEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateRecommendationStatusRequest build() {
            return new BatchUpdateRecommendationStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
