/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResiliencyScoreType {
    COMPLIANCE("Compliance"),
    TEST("Test"),
    ALARM("Alarm"),
    SOP("Sop"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResiliencyScoreType> VALUE_MAP;
    private final String value;

    private ResiliencyScoreType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResiliencyScoreType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResiliencyScoreType> knownValues() {
        EnumSet<ResiliencyScoreType> knownValues = EnumSet.allOf(ResiliencyScoreType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResiliencyScoreType.class, ResiliencyScoreType::toString);
    }
}

