/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceMapping;
import software.amazon.awssdk.services.resiliencehub.model.ResourceMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddDraftAppVersionResourceMappingsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, AddDraftAppVersionResourceMappingsResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(AddDraftAppVersionResourceMappingsResponse.getter(AddDraftAppVersionResourceMappingsResponse::appArn)).setter(AddDraftAppVersionResourceMappingsResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(AddDraftAppVersionResourceMappingsResponse.getter(AddDraftAppVersionResourceMappingsResponse::appVersion)).setter(AddDraftAppVersionResourceMappingsResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<List<ResourceMapping>> RESOURCE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceMappings").getter(AddDraftAppVersionResourceMappingsResponse.getter(AddDraftAppVersionResourceMappingsResponse::resourceMappings)).setter(AddDraftAppVersionResourceMappingsResponse.setter(Builder::resourceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_VERSION_FIELD, RESOURCE_MAPPINGS_FIELD));
    private final String appArn;
    private final String appVersion;
    private final List<ResourceMapping> resourceMappings;

    private AddDraftAppVersionResourceMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appVersion = builder.appVersion;
        this.resourceMappings = builder.resourceMappings;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public final boolean hasResourceMappings() {
        return this.resourceMappings != null && !(this.resourceMappings instanceof SdkAutoConstructList);
    }

    public final List<ResourceMapping> resourceMappings() {
        return this.resourceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceMappings() ? this.resourceMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddDraftAppVersionResourceMappingsResponse)) {
            return false;
        }
        AddDraftAppVersionResourceMappingsResponse other = (AddDraftAppVersionResourceMappingsResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appVersion(), other.appVersion()) && this.hasResourceMappings() == other.hasResourceMappings() && Objects.equals(this.resourceMappings(), other.resourceMappings());
    }

    public final String toString() {
        return ToString.builder((String)"AddDraftAppVersionResourceMappingsResponse").add("AppArn", (Object)this.appArn()).add("AppVersion", (Object)this.appVersion()).add("ResourceMappings", this.hasResourceMappings() ? this.resourceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "resourceMappings": {
                return Optional.ofNullable(clazz.cast(this.resourceMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddDraftAppVersionResourceMappingsResponse, T> g) {
        return obj -> g.apply((AddDraftAppVersionResourceMappingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private String appVersion;
        private List<ResourceMapping> resourceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddDraftAppVersionResourceMappingsResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appVersion(model.appVersion);
            this.resourceMappings(model.resourceMappings);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final List<ResourceMapping.Builder> getResourceMappings() {
            List<ResourceMapping.Builder> result = ResourceMappingListCopier.copyToBuilder(this.resourceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceMappings(Collection<ResourceMapping.BuilderImpl> resourceMappings) {
            this.resourceMappings = ResourceMappingListCopier.copyFromBuilder(resourceMappings);
        }

        @Override
        public final Builder resourceMappings(Collection<ResourceMapping> resourceMappings) {
            this.resourceMappings = ResourceMappingListCopier.copy(resourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(ResourceMapping ... resourceMappings) {
            this.resourceMappings(Arrays.asList(resourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(Consumer<ResourceMapping.Builder> ... resourceMappings) {
            this.resourceMappings(Stream.of(resourceMappings).map(c -> (ResourceMapping)((ResourceMapping.Builder)ResourceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddDraftAppVersionResourceMappingsResponse build() {
            return new AddDraftAppVersionResourceMappingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddDraftAppVersionResourceMappingsResponse> {
        public Builder appArn(String var1);

        public Builder appVersion(String var1);

        public Builder resourceMappings(Collection<ResourceMapping> var1);

        public Builder resourceMappings(ResourceMapping ... var1);

        public Builder resourceMappings(Consumer<ResourceMapping.Builder> ... var1);
    }
}

