/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppComponentCompliancesResponse;

public class ListAppComponentCompliancesPublisher
implements SdkPublisher<ListAppComponentCompliancesResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAppComponentCompliancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppComponentCompliancesPublisher(ResiliencehubAsyncClient client, ListAppComponentCompliancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppComponentCompliancesPublisher(ResiliencehubAsyncClient client, ListAppComponentCompliancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppComponentCompliancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppComponentCompliancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppComponentCompliancesResponseFetcher
    implements AsyncPageFetcher<ListAppComponentCompliancesResponse> {
        private ListAppComponentCompliancesResponseFetcher() {
        }

        public boolean hasNextPage(ListAppComponentCompliancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppComponentCompliancesResponse> nextPage(ListAppComponentCompliancesResponse previousPage) {
            if (previousPage == null) {
                return ListAppComponentCompliancesPublisher.this.client.listAppComponentCompliances(ListAppComponentCompliancesPublisher.this.firstRequest);
            }
            return ListAppComponentCompliancesPublisher.this.client.listAppComponentCompliances((ListAppComponentCompliancesRequest)((Object)ListAppComponentCompliancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

