/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationItem.Builder, RecommendationItem> {
    private static final SdkField<Boolean> ALREADY_IMPLEMENTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("alreadyImplemented").getter(getter(RecommendationItem::alreadyImplemented))
            .setter(setter(Builder::alreadyImplemented))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alreadyImplemented").build())
            .build();

    private static final SdkField<String> EXCLUDE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("excludeReason").getter(getter(RecommendationItem::excludeReasonAsString))
            .setter(setter(Builder::excludeReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeReason").build()).build();

    private static final SdkField<Boolean> EXCLUDED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("excluded").getter(getter(RecommendationItem::excluded)).setter(setter(Builder::excluded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excluded").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(RecommendationItem::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> TARGET_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetAccountId").getter(getter(RecommendationItem::targetAccountId))
            .setter(setter(Builder::targetAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAccountId").build()).build();

    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetRegion").getter(getter(RecommendationItem::targetRegion)).setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALREADY_IMPLEMENTED_FIELD,
            EXCLUDE_REASON_FIELD, EXCLUDED_FIELD, RESOURCE_ID_FIELD, TARGET_ACCOUNT_ID_FIELD, TARGET_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean alreadyImplemented;

    private final String excludeReason;

    private final Boolean excluded;

    private final String resourceId;

    private final String targetAccountId;

    private final String targetRegion;

    private RecommendationItem(BuilderImpl builder) {
        this.alreadyImplemented = builder.alreadyImplemented;
        this.excludeReason = builder.excludeReason;
        this.excluded = builder.excluded;
        this.resourceId = builder.resourceId;
        this.targetAccountId = builder.targetAccountId;
        this.targetRegion = builder.targetRegion;
    }

    /**
     * <p>
     * Specifies if the recommendation has already been implemented.
     * </p>
     * 
     * @return Specifies if the recommendation has already been implemented.
     */
    public final Boolean alreadyImplemented() {
        return alreadyImplemented;
    }

    /**
     * <p>
     * Indicates the reason for excluding an operational recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #excludeReason}
     * will return {@link ExcludeRecommendationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excludeReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for excluding an operational recommendation.
     * @see ExcludeRecommendationReason
     */
    public final ExcludeRecommendationReason excludeReason() {
        return ExcludeRecommendationReason.fromValue(excludeReason);
    }

    /**
     * <p>
     * Indicates the reason for excluding an operational recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #excludeReason}
     * will return {@link ExcludeRecommendationReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #excludeReasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for excluding an operational recommendation.
     * @see ExcludeRecommendationReason
     */
    public final String excludeReasonAsString() {
        return excludeReason;
    }

    /**
     * <p>
     * Indicates if an operational recommendation item is excluded.
     * </p>
     * 
     * @return Indicates if an operational recommendation item is excluded.
     */
    public final Boolean excluded() {
        return excluded;
    }

    /**
     * <p>
     * Identifier of the resource.
     * </p>
     * 
     * @return Identifier of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Identifier of the target account.
     * </p>
     * 
     * @return Identifier of the target account.
     */
    public final String targetAccountId() {
        return targetAccountId;
    }

    /**
     * <p>
     * The target region.
     * </p>
     * 
     * @return The target region.
     */
    public final String targetRegion() {
        return targetRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(alreadyImplemented());
        hashCode = 31 * hashCode + Objects.hashCode(excludeReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(excluded());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(targetAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationItem)) {
            return false;
        }
        RecommendationItem other = (RecommendationItem) obj;
        return Objects.equals(alreadyImplemented(), other.alreadyImplemented())
                && Objects.equals(excludeReasonAsString(), other.excludeReasonAsString())
                && Objects.equals(excluded(), other.excluded()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(targetAccountId(), other.targetAccountId())
                && Objects.equals(targetRegion(), other.targetRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationItem").add("AlreadyImplemented", alreadyImplemented())
                .add("ExcludeReason", excludeReasonAsString()).add("Excluded", excluded()).add("ResourceId", resourceId())
                .add("TargetAccountId", targetAccountId()).add("TargetRegion", targetRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "alreadyImplemented":
            return Optional.ofNullable(clazz.cast(alreadyImplemented()));
        case "excludeReason":
            return Optional.ofNullable(clazz.cast(excludeReasonAsString()));
        case "excluded":
            return Optional.ofNullable(clazz.cast(excluded()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "targetAccountId":
            return Optional.ofNullable(clazz.cast(targetAccountId()));
        case "targetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationItem, T> g) {
        return obj -> g.apply((RecommendationItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationItem> {
        /**
         * <p>
         * Specifies if the recommendation has already been implemented.
         * </p>
         * 
         * @param alreadyImplemented
         *        Specifies if the recommendation has already been implemented.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alreadyImplemented(Boolean alreadyImplemented);

        /**
         * <p>
         * Indicates the reason for excluding an operational recommendation.
         * </p>
         * 
         * @param excludeReason
         *        Indicates the reason for excluding an operational recommendation.
         * @see ExcludeRecommendationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcludeRecommendationReason
         */
        Builder excludeReason(String excludeReason);

        /**
         * <p>
         * Indicates the reason for excluding an operational recommendation.
         * </p>
         * 
         * @param excludeReason
         *        Indicates the reason for excluding an operational recommendation.
         * @see ExcludeRecommendationReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExcludeRecommendationReason
         */
        Builder excludeReason(ExcludeRecommendationReason excludeReason);

        /**
         * <p>
         * Indicates if an operational recommendation item is excluded.
         * </p>
         * 
         * @param excluded
         *        Indicates if an operational recommendation item is excluded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excluded(Boolean excluded);

        /**
         * <p>
         * Identifier of the resource.
         * </p>
         * 
         * @param resourceId
         *        Identifier of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Identifier of the target account.
         * </p>
         * 
         * @param targetAccountId
         *        Identifier of the target account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAccountId(String targetAccountId);

        /**
         * <p>
         * The target region.
         * </p>
         * 
         * @param targetRegion
         *        The target region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);
    }

    static final class BuilderImpl implements Builder {
        private Boolean alreadyImplemented;

        private String excludeReason;

        private Boolean excluded;

        private String resourceId;

        private String targetAccountId;

        private String targetRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationItem model) {
            alreadyImplemented(model.alreadyImplemented);
            excludeReason(model.excludeReason);
            excluded(model.excluded);
            resourceId(model.resourceId);
            targetAccountId(model.targetAccountId);
            targetRegion(model.targetRegion);
        }

        public final Boolean getAlreadyImplemented() {
            return alreadyImplemented;
        }

        public final void setAlreadyImplemented(Boolean alreadyImplemented) {
            this.alreadyImplemented = alreadyImplemented;
        }

        @Override
        public final Builder alreadyImplemented(Boolean alreadyImplemented) {
            this.alreadyImplemented = alreadyImplemented;
            return this;
        }

        public final String getExcludeReason() {
            return excludeReason;
        }

        public final void setExcludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
        }

        @Override
        public final Builder excludeReason(String excludeReason) {
            this.excludeReason = excludeReason;
            return this;
        }

        @Override
        public final Builder excludeReason(ExcludeRecommendationReason excludeReason) {
            this.excludeReason(excludeReason == null ? null : excludeReason.toString());
            return this;
        }

        public final Boolean getExcluded() {
            return excluded;
        }

        public final void setExcluded(Boolean excluded) {
            this.excluded = excluded;
        }

        @Override
        public final Builder excluded(Boolean excluded) {
            this.excluded = excluded;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getTargetAccountId() {
            return targetAccountId;
        }

        public final void setTargetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
        }

        @Override
        public final Builder targetAccountId(String targetAccountId) {
            this.targetAccountId = targetAccountId;
            return this;
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        @Override
        public RecommendationItem build() {
            return new RecommendationItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
