/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends ResiliencehubRequest implements
        ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<String> ASSESSMENT_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assessmentSchedule").getter(getter(CreateAppRequest::assessmentScheduleAsString))
            .setter(setter(Builder::assessmentSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessmentSchedule").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAppRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<EventSubscription>> EVENT_SUBSCRIPTIONS_FIELD = SdkField
            .<List<EventSubscription>> builder(MarshallingType.LIST)
            .memberName("eventSubscriptions")
            .getter(getter(CreateAppRequest::eventSubscriptions))
            .setter(setter(Builder::eventSubscriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSubscriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSubscription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSubscription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAppRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PermissionModel> PERMISSION_MODEL_FIELD = SdkField
            .<PermissionModel> builder(MarshallingType.SDK_POJO).memberName("permissionModel")
            .getter(getter(CreateAppRequest::permissionModel)).setter(setter(Builder::permissionModel))
            .constructor(PermissionModel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionModel").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(CreateAppRequest::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_SCHEDULE_FIELD,
            CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, EVENT_SUBSCRIPTIONS_FIELD, NAME_FIELD, PERMISSION_MODEL_FIELD,
            POLICY_ARN_FIELD, TAGS_FIELD));

    private final String assessmentSchedule;

    private final String clientToken;

    private final String description;

    private final List<EventSubscription> eventSubscriptions;

    private final String name;

    private final PermissionModel permissionModel;

    private final String policyArn;

    private final Map<String, String> tags;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.assessmentSchedule = builder.assessmentSchedule;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.eventSubscriptions = builder.eventSubscriptions;
        this.name = builder.name;
        this.permissionModel = builder.permissionModel;
        this.policyArn = builder.policyArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final AppAssessmentScheduleType assessmentSchedule() {
        return AppAssessmentScheduleType.fromValue(assessmentSchedule);
    }

    /**
     * <p>
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #assessmentSchedule} will return {@link AppAssessmentScheduleType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #assessmentScheduleAsString}.
     * </p>
     * 
     * @return Assessment execution schedule with 'Daily' or 'Disabled' values.
     * @see AppAssessmentScheduleType
     */
    public final String assessmentScheduleAsString() {
        return assessmentSchedule;
    }

    /**
     * <p>
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters.
     * You should not reuse the same client token for other API requests.
     * </p>
     * 
     * @return Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
     *         characters. You should not reuse the same client token for other API requests.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The optional description for an app.
     * </p>
     * 
     * @return The optional description for an app.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventSubscriptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventSubscriptions() {
        return eventSubscriptions != null && !(eventSubscriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports only
     * <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventSubscriptions} method.
     * </p>
     * 
     * @return The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
     *         supports only <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.
     */
    public final List<EventSubscription> eventSubscriptions() {
        return eventSubscriptions;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its
     * resources, and running an assessment.
     * </p>
     * 
     * @return Defines the roles and credentials that Resilience Hub would use while creating the application, importing
     *         its resources, and running an assessment.
     */
    public final PermissionModel permissionModel() {
        return permissionModel;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
     * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
     * information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">
     * Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
     *         <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
     *         <code>policy-id</code>. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
     * consists of a key/value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each
     *         tag consists of a key/value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assessmentScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventSubscriptions() ? eventSubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(permissionModel());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(assessmentScheduleAsString(), other.assessmentScheduleAsString())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && hasEventSubscriptions() == other.hasEventSubscriptions()
                && Objects.equals(eventSubscriptions(), other.eventSubscriptions()) && Objects.equals(name(), other.name())
                && Objects.equals(permissionModel(), other.permissionModel()) && Objects.equals(policyArn(), other.policyArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppRequest").add("AssessmentSchedule", assessmentScheduleAsString())
                .add("ClientToken", clientToken()).add("Description", description())
                .add("EventSubscriptions", hasEventSubscriptions() ? eventSubscriptions() : null).add("Name", name())
                .add("PermissionModel", permissionModel()).add("PolicyArn", policyArn())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assessmentSchedule":
            return Optional.ofNullable(clazz.cast(assessmentScheduleAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "eventSubscriptions":
            return Optional.ofNullable(clazz.cast(eventSubscriptions()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "permissionModel":
            return Optional.ofNullable(clazz.cast(permissionModel()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(String assessmentSchedule);

        /**
         * <p>
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         * </p>
         * 
         * @param assessmentSchedule
         *        Assessment execution schedule with 'Daily' or 'Disabled' values.
         * @see AppAssessmentScheduleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppAssessmentScheduleType
         */
        Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule);

        /**
         * <p>
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         * characters. You should not reuse the same client token for other API requests.
         * </p>
         * 
         * @param clientToken
         *        Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII
         *        characters. You should not reuse the same client token for other API requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The optional description for an app.
         * </p>
         * 
         * @param description
         *        The optional description for an app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * only <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports only <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * only <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.
         * </p>
         * 
         * @param eventSubscriptions
         *        The list of events you would like to subscribe and get notification for. Currently, Resilience Hub
         *        supports only <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptions(EventSubscription... eventSubscriptions);

        /**
         * <p>
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports
         * only <b>Drift detected</b> and <b>Scheduled assessment failure</b> events notification.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder#build()} is called
         * immediately and its result is passed to {@link #eventSubscriptions(List<EventSubscription>)}.
         * 
         * @param eventSubscriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.EventSubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSubscriptions(java.util.Collection<EventSubscription>)
         */
        Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions);

        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param name
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its
         * resources, and running an assessment.
         * </p>
         * 
         * @param permissionModel
         *        Defines the roles and credentials that Resilience Hub would use while creating the application,
         *        importing its resources, and running an assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionModel(PermissionModel permissionModel);

        /**
         * <p>
         * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its
         * resources, and running an assessment.
         * </p>
         * This is a convenience method that creates an instance of the {@link PermissionModel.Builder} avoiding the
         * need to create one manually via {@link PermissionModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PermissionModel.Builder#build()} is called immediately and its
         * result is passed to {@link #permissionModel(PermissionModel)}.
         * 
         * @param permissionModel
         *        a consumer that will call methods on {@link PermissionModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionModel(PermissionModel)
         */
        default Builder permissionModel(Consumer<PermissionModel.Builder> permissionModel) {
            return permissionModel(PermissionModel.builder().applyMutation(permissionModel).build());
        }

        /**
         * <p>
         * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:<code>partition</code>
         * :resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/<code>policy-id</code>. For more
         * information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param policyArn
         *        Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:
         *        <code>partition</code>:resiliencehub:<code>region</code>:<code>account</code>:resiliency-policy/
         *        <code>policy-id</code>. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag
         * consists of a key/value pair.
         * </p>
         * 
         * @param tags
         *        Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource.
         *        Each tag consists of a key/value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResiliencehubRequest.BuilderImpl implements Builder {
        private String assessmentSchedule;

        private String clientToken;

        private String description;

        private List<EventSubscription> eventSubscriptions = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private PermissionModel permissionModel;

        private String policyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            assessmentSchedule(model.assessmentSchedule);
            clientToken(model.clientToken);
            description(model.description);
            eventSubscriptions(model.eventSubscriptions);
            name(model.name);
            permissionModel(model.permissionModel);
            policyArn(model.policyArn);
            tags(model.tags);
        }

        public final String getAssessmentSchedule() {
            return assessmentSchedule;
        }

        public final void setAssessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
        }

        @Override
        public final Builder assessmentSchedule(String assessmentSchedule) {
            this.assessmentSchedule = assessmentSchedule;
            return this;
        }

        @Override
        public final Builder assessmentSchedule(AppAssessmentScheduleType assessmentSchedule) {
            this.assessmentSchedule(assessmentSchedule == null ? null : assessmentSchedule.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<EventSubscription.Builder> getEventSubscriptions() {
            List<EventSubscription.Builder> result = EventSubscriptionListCopier.copyToBuilder(this.eventSubscriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventSubscriptions(Collection<EventSubscription.BuilderImpl> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copyFromBuilder(eventSubscriptions);
        }

        @Override
        public final Builder eventSubscriptions(Collection<EventSubscription> eventSubscriptions) {
            this.eventSubscriptions = EventSubscriptionListCopier.copy(eventSubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(EventSubscription... eventSubscriptions) {
            eventSubscriptions(Arrays.asList(eventSubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptions(Consumer<EventSubscription.Builder>... eventSubscriptions) {
            eventSubscriptions(Stream.of(eventSubscriptions).map(c -> EventSubscription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PermissionModel.Builder getPermissionModel() {
            return permissionModel != null ? permissionModel.toBuilder() : null;
        }

        public final void setPermissionModel(PermissionModel.BuilderImpl permissionModel) {
            this.permissionModel = permissionModel != null ? permissionModel.build() : null;
        }

        @Override
        public final Builder permissionModel(PermissionModel permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
