/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of Resilience Hub application input sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInputSource implements SdkPojo, Serializable, ToCopyableBuilder<AppInputSource.Builder, AppInputSource> {
    private static final SdkField<EksSourceClusterNamespace> EKS_SOURCE_CLUSTER_NAMESPACE_FIELD = SdkField
            .<EksSourceClusterNamespace> builder(MarshallingType.SDK_POJO).memberName("eksSourceClusterNamespace")
            .getter(getter(AppInputSource::eksSourceClusterNamespace)).setter(setter(Builder::eksSourceClusterNamespace))
            .constructor(EksSourceClusterNamespace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSourceClusterNamespace").build())
            .build();

    private static final SdkField<String> IMPORT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importType").getter(getter(AppInputSource::importTypeAsString)).setter(setter(Builder::importType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importType").build()).build();

    private static final SdkField<Integer> RESOURCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("resourceCount").getter(getter(AppInputSource::resourceCount)).setter(setter(Builder::resourceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceCount").build()).build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceArn").getter(getter(AppInputSource::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceName").getter(getter(AppInputSource::sourceName)).setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceName").build()).build();

    private static final SdkField<TerraformSource> TERRAFORM_SOURCE_FIELD = SdkField
            .<TerraformSource> builder(MarshallingType.SDK_POJO).memberName("terraformSource")
            .getter(getter(AppInputSource::terraformSource)).setter(setter(Builder::terraformSource))
            .constructor(TerraformSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EKS_SOURCE_CLUSTER_NAMESPACE_FIELD, IMPORT_TYPE_FIELD, RESOURCE_COUNT_FIELD, SOURCE_ARN_FIELD, SOURCE_NAME_FIELD,
            TERRAFORM_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final EksSourceClusterNamespace eksSourceClusterNamespace;

    private final String importType;

    private final Integer resourceCount;

    private final String sourceArn;

    private final String sourceName;

    private final TerraformSource terraformSource;

    private AppInputSource(BuilderImpl builder) {
        this.eksSourceClusterNamespace = builder.eksSourceClusterNamespace;
        this.importType = builder.importType;
        this.resourceCount = builder.resourceCount;
        this.sourceArn = builder.sourceArn;
        this.sourceName = builder.sourceName;
        this.terraformSource = builder.terraformSource;
    }

    /**
     * <p>
     * The namespace on your Amazon Elastic Kubernetes Service cluster.
     * </p>
     * 
     * @return The namespace on your Amazon Elastic Kubernetes Service cluster.
     */
    public final EksSourceClusterNamespace eksSourceClusterNamespace() {
        return eksSourceClusterNamespace;
    }

    /**
     * <p>
     * The resource type of the input source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importType} will
     * return {@link ResourceMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #importTypeAsString}.
     * </p>
     * 
     * @return The resource type of the input source.
     * @see ResourceMappingType
     */
    public final ResourceMappingType importType() {
        return ResourceMappingType.fromValue(importType);
    }

    /**
     * <p>
     * The resource type of the input source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #importType} will
     * return {@link ResourceMappingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #importTypeAsString}.
     * </p>
     * 
     * @return The resource type of the input source.
     * @see ResourceMappingType
     */
    public final String importTypeAsString() {
        return importType;
    }

    /**
     * <p>
     * The number of resources.
     * </p>
     * 
     * @return The number of resources.
     */
    public final Integer resourceCount() {
        return resourceCount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the input source. For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the input source. For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The name of the input source.
     * </p>
     * 
     * @return The name of the input source.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The name of the Terraform s3 state ﬁle.
     * </p>
     * 
     * @return The name of the Terraform s3 state ﬁle.
     */
    public final TerraformSource terraformSource() {
        return terraformSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eksSourceClusterNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(importTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCount());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(terraformSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInputSource)) {
            return false;
        }
        AppInputSource other = (AppInputSource) obj;
        return Objects.equals(eksSourceClusterNamespace(), other.eksSourceClusterNamespace())
                && Objects.equals(importTypeAsString(), other.importTypeAsString())
                && Objects.equals(resourceCount(), other.resourceCount()) && Objects.equals(sourceArn(), other.sourceArn())
                && Objects.equals(sourceName(), other.sourceName()) && Objects.equals(terraformSource(), other.terraformSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInputSource").add("EksSourceClusterNamespace", eksSourceClusterNamespace())
                .add("ImportType", importTypeAsString()).add("ResourceCount", resourceCount()).add("SourceArn", sourceArn())
                .add("SourceName", sourceName()).add("TerraformSource", terraformSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eksSourceClusterNamespace":
            return Optional.ofNullable(clazz.cast(eksSourceClusterNamespace()));
        case "importType":
            return Optional.ofNullable(clazz.cast(importTypeAsString()));
        case "resourceCount":
            return Optional.ofNullable(clazz.cast(resourceCount()));
        case "sourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "sourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "terraformSource":
            return Optional.ofNullable(clazz.cast(terraformSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInputSource, T> g) {
        return obj -> g.apply((AppInputSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInputSource> {
        /**
         * <p>
         * The namespace on your Amazon Elastic Kubernetes Service cluster.
         * </p>
         * 
         * @param eksSourceClusterNamespace
         *        The namespace on your Amazon Elastic Kubernetes Service cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksSourceClusterNamespace(EksSourceClusterNamespace eksSourceClusterNamespace);

        /**
         * <p>
         * The namespace on your Amazon Elastic Kubernetes Service cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksSourceClusterNamespace.Builder}
         * avoiding the need to create one manually via {@link EksSourceClusterNamespace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksSourceClusterNamespace.Builder#build()} is called immediately
         * and its result is passed to {@link #eksSourceClusterNamespace(EksSourceClusterNamespace)}.
         * 
         * @param eksSourceClusterNamespace
         *        a consumer that will call methods on {@link EksSourceClusterNamespace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksSourceClusterNamespace(EksSourceClusterNamespace)
         */
        default Builder eksSourceClusterNamespace(Consumer<EksSourceClusterNamespace.Builder> eksSourceClusterNamespace) {
            return eksSourceClusterNamespace(EksSourceClusterNamespace.builder().applyMutation(eksSourceClusterNamespace).build());
        }

        /**
         * <p>
         * The resource type of the input source.
         * </p>
         * 
         * @param importType
         *        The resource type of the input source.
         * @see ResourceMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceMappingType
         */
        Builder importType(String importType);

        /**
         * <p>
         * The resource type of the input source.
         * </p>
         * 
         * @param importType
         *        The resource type of the input source.
         * @see ResourceMappingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceMappingType
         */
        Builder importType(ResourceMappingType importType);

        /**
         * <p>
         * The number of resources.
         * </p>
         * 
         * @param resourceCount
         *        The number of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCount(Integer resourceCount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the input source. For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) of the input source. For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html"> Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i> guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The name of the input source.
         * </p>
         * 
         * @param sourceName
         *        The name of the input source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The name of the Terraform s3 state ﬁle.
         * </p>
         * 
         * @param terraformSource
         *        The name of the Terraform s3 state ﬁle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terraformSource(TerraformSource terraformSource);

        /**
         * <p>
         * The name of the Terraform s3 state ﬁle.
         * </p>
         * This is a convenience method that creates an instance of the {@link TerraformSource.Builder} avoiding the
         * need to create one manually via {@link TerraformSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TerraformSource.Builder#build()} is called immediately and its
         * result is passed to {@link #terraformSource(TerraformSource)}.
         * 
         * @param terraformSource
         *        a consumer that will call methods on {@link TerraformSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terraformSource(TerraformSource)
         */
        default Builder terraformSource(Consumer<TerraformSource.Builder> terraformSource) {
            return terraformSource(TerraformSource.builder().applyMutation(terraformSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EksSourceClusterNamespace eksSourceClusterNamespace;

        private String importType;

        private Integer resourceCount;

        private String sourceArn;

        private String sourceName;

        private TerraformSource terraformSource;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInputSource model) {
            eksSourceClusterNamespace(model.eksSourceClusterNamespace);
            importType(model.importType);
            resourceCount(model.resourceCount);
            sourceArn(model.sourceArn);
            sourceName(model.sourceName);
            terraformSource(model.terraformSource);
        }

        public final EksSourceClusterNamespace.Builder getEksSourceClusterNamespace() {
            return eksSourceClusterNamespace != null ? eksSourceClusterNamespace.toBuilder() : null;
        }

        public final void setEksSourceClusterNamespace(EksSourceClusterNamespace.BuilderImpl eksSourceClusterNamespace) {
            this.eksSourceClusterNamespace = eksSourceClusterNamespace != null ? eksSourceClusterNamespace.build() : null;
        }

        @Override
        public final Builder eksSourceClusterNamespace(EksSourceClusterNamespace eksSourceClusterNamespace) {
            this.eksSourceClusterNamespace = eksSourceClusterNamespace;
            return this;
        }

        public final String getImportType() {
            return importType;
        }

        public final void setImportType(String importType) {
            this.importType = importType;
        }

        @Override
        public final Builder importType(String importType) {
            this.importType = importType;
            return this;
        }

        @Override
        public final Builder importType(ResourceMappingType importType) {
            this.importType(importType == null ? null : importType.toString());
            return this;
        }

        public final Integer getResourceCount() {
            return resourceCount;
        }

        public final void setResourceCount(Integer resourceCount) {
            this.resourceCount = resourceCount;
        }

        @Override
        public final Builder resourceCount(Integer resourceCount) {
            this.resourceCount = resourceCount;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final TerraformSource.Builder getTerraformSource() {
            return terraformSource != null ? terraformSource.toBuilder() : null;
        }

        public final void setTerraformSource(TerraformSource.BuilderImpl terraformSource) {
            this.terraformSource = terraformSource != null ? terraformSource.build() : null;
        }

        @Override
        public final Builder terraformSource(TerraformSource terraformSource) {
            this.terraformSource = terraformSource;
            return this;
        }

        @Override
        public AppInputSource build() {
            return new AppInputSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
