/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DisruptionType {
    SOFTWARE("Software"),
    HARDWARE("Hardware"),
    AZ("AZ"),
    REGION("Region"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DisruptionType> VALUE_MAP;
    private final String value;

    private DisruptionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DisruptionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DisruptionType> knownValues() {
        EnumSet<DisruptionType> knownValues = EnumSet.allOf(DisruptionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DisruptionType.class, DisruptionType::toString);
    }
}

