/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksSourceClusterNamespace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksSourceClusterNamespace> {
    private static final SdkField<String> EKS_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eksClusterArn").getter(EksSourceClusterNamespace.getter(EksSourceClusterNamespace::eksClusterArn)).setter(EksSourceClusterNamespace.setter(Builder::eksClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksClusterArn").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(EksSourceClusterNamespace.getter(EksSourceClusterNamespace::namespace)).setter(EksSourceClusterNamespace.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_CLUSTER_ARN_FIELD, NAMESPACE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eksClusterArn;
    private final String namespace;

    private EksSourceClusterNamespace(BuilderImpl builder) {
        this.eksClusterArn = builder.eksClusterArn;
        this.namespace = builder.namespace;
    }

    public final String eksClusterArn() {
        return this.eksClusterArn;
    }

    public final String namespace() {
        return this.namespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksSourceClusterNamespace)) {
            return false;
        }
        EksSourceClusterNamespace other = (EksSourceClusterNamespace)obj;
        return Objects.equals(this.eksClusterArn(), other.eksClusterArn()) && Objects.equals(this.namespace(), other.namespace());
    }

    public final String toString() {
        return ToString.builder((String)"EksSourceClusterNamespace").add("EksClusterArn", (Object)this.eksClusterArn()).add("Namespace", (Object)this.namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksClusterArn": {
                return Optional.ofNullable(clazz.cast(this.eksClusterArn()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EksSourceClusterNamespace, T> g) {
        return obj -> g.apply((EksSourceClusterNamespace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eksClusterArn;
        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(EksSourceClusterNamespace model) {
            this.eksClusterArn(model.eksClusterArn);
            this.namespace(model.namespace);
        }

        public final String getEksClusterArn() {
            return this.eksClusterArn;
        }

        public final void setEksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
        }

        @Override
        public final Builder eksClusterArn(String eksClusterArn) {
            this.eksClusterArn = eksClusterArn;
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public EksSourceClusterNamespace build() {
            return new EksSourceClusterNamespace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksSourceClusterNamespace> {
        public Builder eksClusterArn(String var1);

        public Builder namespace(String var1);
    }
}

