/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.services.resiliencehub.model.ResourceDrift;
import software.amazon.awssdk.services.resiliencehub.model.ResourceDriftListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppAssessmentResourceDriftsResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppAssessmentResourceDriftsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppAssessmentResourceDriftsResponse.getter(ListAppAssessmentResourceDriftsResponse::nextToken)).setter(ListAppAssessmentResourceDriftsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResourceDrift>> RESOURCE_DRIFTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceDrifts").getter(ListAppAssessmentResourceDriftsResponse.getter(ListAppAssessmentResourceDriftsResponse::resourceDrifts)).setter(ListAppAssessmentResourceDriftsResponse.setter(Builder::resourceDrifts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceDrifts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceDrift::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESOURCE_DRIFTS_FIELD));
    private final String nextToken;
    private final List<ResourceDrift> resourceDrifts;

    private ListAppAssessmentResourceDriftsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourceDrifts = builder.resourceDrifts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResourceDrifts() {
        return this.resourceDrifts != null && !(this.resourceDrifts instanceof SdkAutoConstructList);
    }

    public final List<ResourceDrift> resourceDrifts() {
        return this.resourceDrifts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceDrifts() ? this.resourceDrifts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppAssessmentResourceDriftsResponse)) {
            return false;
        }
        ListAppAssessmentResourceDriftsResponse other = (ListAppAssessmentResourceDriftsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResourceDrifts() == other.hasResourceDrifts() && Objects.equals(this.resourceDrifts(), other.resourceDrifts());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppAssessmentResourceDriftsResponse").add("NextToken", (Object)this.nextToken()).add("ResourceDrifts", this.hasResourceDrifts() ? this.resourceDrifts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "resourceDrifts": {
                return Optional.ofNullable(clazz.cast(this.resourceDrifts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppAssessmentResourceDriftsResponse, T> g) {
        return obj -> g.apply((ListAppAssessmentResourceDriftsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResourceDrift> resourceDrifts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppAssessmentResourceDriftsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.resourceDrifts(model.resourceDrifts);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourceDrift.Builder> getResourceDrifts() {
            List<ResourceDrift.Builder> result = ResourceDriftListCopier.copyToBuilder(this.resourceDrifts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceDrifts(Collection<ResourceDrift.BuilderImpl> resourceDrifts) {
            this.resourceDrifts = ResourceDriftListCopier.copyFromBuilder(resourceDrifts);
        }

        @Override
        public final Builder resourceDrifts(Collection<ResourceDrift> resourceDrifts) {
            this.resourceDrifts = ResourceDriftListCopier.copy(resourceDrifts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDrifts(ResourceDrift ... resourceDrifts) {
            this.resourceDrifts(Arrays.asList(resourceDrifts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceDrifts(Consumer<ResourceDrift.Builder> ... resourceDrifts) {
            this.resourceDrifts(Stream.of(resourceDrifts).map(c -> (ResourceDrift)((ResourceDrift.Builder)ResourceDrift.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAppAssessmentResourceDriftsResponse build() {
            return new ListAppAssessmentResourceDriftsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppAssessmentResourceDriftsResponse> {
        public Builder nextToken(String var1);

        public Builder resourceDrifts(Collection<ResourceDrift> var1);

        public Builder resourceDrifts(ResourceDrift ... var1);

        public Builder resourceDrifts(Consumer<ResourceDrift.Builder> ... var1);
    }
}

