/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubAsyncClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse;

public class ListAppVersionsPublisher
implements SdkPublisher<ListAppVersionsResponse> {
    private final ResiliencehubAsyncClient client;
    private final ListAppVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppVersionsPublisher(ResiliencehubAsyncClient client, ListAppVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppVersionsPublisher(ResiliencehubAsyncClient client, ListAppVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppVersionsResponseFetcher
    implements AsyncPageFetcher<ListAppVersionsResponse> {
        private ListAppVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppVersionsResponse> nextPage(ListAppVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAppVersionsPublisher.this.client.listAppVersions(ListAppVersionsPublisher.this.firstRequest);
            }
            return ListAppVersionsPublisher.this.client.listAppVersions((ListAppVersionsRequest)((Object)ListAppVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

