/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.resiliencehub.model.AppComponent;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAppVersionAppComponentResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, CreateAppVersionAppComponentResponse> {
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(CreateAppVersionAppComponentResponse.getter(CreateAppVersionAppComponentResponse::appArn)).setter(CreateAppVersionAppComponentResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<AppComponent> APP_COMPONENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("appComponent").getter(CreateAppVersionAppComponentResponse.getter(CreateAppVersionAppComponentResponse::appComponent)).setter(CreateAppVersionAppComponentResponse.setter(Builder::appComponent)).constructor(AppComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponent").build()}).build();
    private static final SdkField<String> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appVersion").getter(CreateAppVersionAppComponentResponse.getter(CreateAppVersionAppComponentResponse::appVersion)).setter(CreateAppVersionAppComponentResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ARN_FIELD, APP_COMPONENT_FIELD, APP_VERSION_FIELD));
    private final String appArn;
    private final AppComponent appComponent;
    private final String appVersion;

    private CreateAppVersionAppComponentResponse(BuilderImpl builder) {
        super(builder);
        this.appArn = builder.appArn;
        this.appComponent = builder.appComponent;
        this.appVersion = builder.appVersion;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final AppComponent appComponent() {
        return this.appComponent;
    }

    public final String appVersion() {
        return this.appVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponent());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppVersionAppComponentResponse)) {
            return false;
        }
        CreateAppVersionAppComponentResponse other = (CreateAppVersionAppComponentResponse)((Object)obj);
        return Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.appComponent(), other.appComponent()) && Objects.equals(this.appVersion(), other.appVersion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAppVersionAppComponentResponse").add("AppArn", (Object)this.appArn()).add("AppComponent", (Object)this.appComponent()).add("AppVersion", (Object)this.appVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "appComponent": {
                return Optional.ofNullable(clazz.cast(this.appComponent()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppVersionAppComponentResponse, T> g) {
        return obj -> g.apply((CreateAppVersionAppComponentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String appArn;
        private AppComponent appComponent;
        private String appVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppVersionAppComponentResponse model) {
            super(model);
            this.appArn(model.appArn);
            this.appComponent(model.appComponent);
            this.appVersion(model.appVersion);
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final AppComponent.Builder getAppComponent() {
            return this.appComponent != null ? this.appComponent.toBuilder() : null;
        }

        public final void setAppComponent(AppComponent.BuilderImpl appComponent) {
            this.appComponent = appComponent != null ? appComponent.build() : null;
        }

        @Override
        public final Builder appComponent(AppComponent appComponent) {
            this.appComponent = appComponent;
            return this;
        }

        public final String getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @Override
        public CreateAppVersionAppComponentResponse build() {
            return new CreateAppVersionAppComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAppVersionAppComponentResponse> {
        public Builder appArn(String var1);

        public Builder appComponent(AppComponent var1);

        default public Builder appComponent(Consumer<AppComponent.Builder> appComponent) {
            return this.appComponent((AppComponent)((AppComponent.Builder)AppComponent.builder().applyMutation(appComponent)).build());
        }

        public Builder appVersion(String var1);
    }
}

