/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ScoringComponentResiliencyScoresCopier {
    static Map<String, ScoringComponentResiliencyScore> copy(
            Map<String, ? extends ScoringComponentResiliencyScore> scoringComponentResiliencyScoresParam) {
        Map<String, ScoringComponentResiliencyScore> map;
        if (scoringComponentResiliencyScoresParam == null || scoringComponentResiliencyScoresParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScoringComponentResiliencyScore> modifiableMap = new LinkedHashMap<>(
                    scoringComponentResiliencyScoresParam.size());
            scoringComponentResiliencyScoresParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ScoringComponentResiliencyScore> copyFromBuilder(
            Map<String, ? extends ScoringComponentResiliencyScore.Builder> scoringComponentResiliencyScoresParam) {
        Map<String, ScoringComponentResiliencyScore> map;
        if (scoringComponentResiliencyScoresParam == null || scoringComponentResiliencyScoresParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScoringComponentResiliencyScore> modifiableMap = new LinkedHashMap<>(
                    scoringComponentResiliencyScoresParam.size());
            scoringComponentResiliencyScoresParam.forEach((key, value) -> {
                ScoringComponentResiliencyScore member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ScoringComponentResiliencyScore.Builder> copyToBuilder(
            Map<String, ? extends ScoringComponentResiliencyScore> scoringComponentResiliencyScoresParam) {
        Map<String, ScoringComponentResiliencyScore.Builder> map;
        if (scoringComponentResiliencyScoresParam == null || scoringComponentResiliencyScoresParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScoringComponentResiliencyScore.Builder> modifiableMap = new LinkedHashMap<>(
                    scoringComponentResiliencyScoresParam.size());
            scoringComponentResiliencyScoresParam.forEach((key, value) -> {
                ScoringComponentResiliencyScore.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ScoringComponentResiliencyScore> copyEnumToString(
            Map<ResiliencyScoreType, ? extends ScoringComponentResiliencyScore> scoringComponentResiliencyScoresParam) {
        Map<String, ScoringComponentResiliencyScore> map;
        if (scoringComponentResiliencyScoresParam == null || scoringComponentResiliencyScoresParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ScoringComponentResiliencyScore> modifiableMap = new LinkedHashMap<>(
                    scoringComponentResiliencyScoresParam.size());
            scoringComponentResiliencyScoresParam.forEach((key, value) -> {
                String result = key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<ResiliencyScoreType, ScoringComponentResiliencyScore> copyStringToEnum(
            Map<String, ? extends ScoringComponentResiliencyScore> scoringComponentResiliencyScoresParam) {
        Map<ResiliencyScoreType, ScoringComponentResiliencyScore> map;
        if (scoringComponentResiliencyScoresParam == null || scoringComponentResiliencyScoresParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<ResiliencyScoreType, ScoringComponentResiliencyScore> modifiableMap = new LinkedHashMap<>(
                    scoringComponentResiliencyScoresParam.size());
            scoringComponentResiliencyScoresParam.forEach((key, value) -> {
                ResiliencyScoreType result = ResiliencyScoreType.fromValue(key);
                if (result != ResiliencyScoreType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
