/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a new recommended Application Component (AppComponent).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupingAppComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupingAppComponent.Builder, GroupingAppComponent> {
    private static final SdkField<String> APP_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentId").getter(getter(GroupingAppComponent::appComponentId))
            .setter(setter(Builder::appComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentId").build()).build();

    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentName").getter(getter(GroupingAppComponent::appComponentName))
            .setter(setter(Builder::appComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()).build();

    private static final SdkField<String> APP_COMPONENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appComponentType").getter(getter(GroupingAppComponent::appComponentType))
            .setter(setter(Builder::appComponentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_ID_FIELD,
            APP_COMPONENT_NAME_FIELD, APP_COMPONENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appComponentId;

    private final String appComponentName;

    private final String appComponentType;

    private GroupingAppComponent(BuilderImpl builder) {
        this.appComponentId = builder.appComponentId;
        this.appComponentName = builder.appComponentName;
        this.appComponentType = builder.appComponentType;
    }

    /**
     * <p>
     * Indicates the identifier of an AppComponent.
     * </p>
     * 
     * @return Indicates the identifier of an AppComponent.
     */
    public final String appComponentId() {
        return appComponentId;
    }

    /**
     * <p>
     * Indicates the name of an AppComponent.
     * </p>
     * 
     * @return Indicates the name of an AppComponent.
     */
    public final String appComponentName() {
        return appComponentName;
    }

    /**
     * <p>
     * Indicates the type of an AppComponent.
     * </p>
     * 
     * @return Indicates the type of an AppComponent.
     */
    public final String appComponentType() {
        return appComponentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(appComponentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingAppComponent)) {
            return false;
        }
        GroupingAppComponent other = (GroupingAppComponent) obj;
        return Objects.equals(appComponentId(), other.appComponentId())
                && Objects.equals(appComponentName(), other.appComponentName())
                && Objects.equals(appComponentType(), other.appComponentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupingAppComponent").add("AppComponentId", appComponentId())
                .add("AppComponentName", appComponentName()).add("AppComponentType", appComponentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appComponentId":
            return Optional.ofNullable(clazz.cast(appComponentId()));
        case "appComponentName":
            return Optional.ofNullable(clazz.cast(appComponentName()));
        case "appComponentType":
            return Optional.ofNullable(clazz.cast(appComponentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupingAppComponent, T> g) {
        return obj -> g.apply((GroupingAppComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupingAppComponent> {
        /**
         * <p>
         * Indicates the identifier of an AppComponent.
         * </p>
         * 
         * @param appComponentId
         *        Indicates the identifier of an AppComponent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentId(String appComponentId);

        /**
         * <p>
         * Indicates the name of an AppComponent.
         * </p>
         * 
         * @param appComponentName
         *        Indicates the name of an AppComponent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentName(String appComponentName);

        /**
         * <p>
         * Indicates the type of an AppComponent.
         * </p>
         * 
         * @param appComponentType
         *        Indicates the type of an AppComponent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appComponentType(String appComponentType);
    }

    static final class BuilderImpl implements Builder {
        private String appComponentId;

        private String appComponentName;

        private String appComponentType;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupingAppComponent model) {
            appComponentId(model.appComponentId);
            appComponentName(model.appComponentName);
            appComponentType(model.appComponentType);
        }

        public final String getAppComponentId() {
            return appComponentId;
        }

        public final void setAppComponentId(String appComponentId) {
            this.appComponentId = appComponentId;
        }

        @Override
        public final Builder appComponentId(String appComponentId) {
            this.appComponentId = appComponentId;
            return this;
        }

        public final String getAppComponentName() {
            return appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final String getAppComponentType() {
            return appComponentType;
        }

        public final void setAppComponentType(String appComponentType) {
            this.appComponentType = appComponentType;
        }

        @Override
        public final Builder appComponentType(String appComponentType) {
            this.appComponentType = appComponentType;
            return this;
        }

        @Override
        public GroupingAppComponent build() {
            return new GroupingAppComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
