/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of errors retrieving an application's resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceErrorsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceErrorsDetails.Builder, ResourceErrorsDetails> {
    private static final SdkField<Boolean> HAS_MORE_ERRORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("hasMoreErrors").getter(getter(ResourceErrorsDetails::hasMoreErrors))
            .setter(setter(Builder::hasMoreErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasMoreErrors").build()).build();

    private static final SdkField<List<ResourceError>> RESOURCE_ERRORS_FIELD = SdkField
            .<List<ResourceError>> builder(MarshallingType.LIST)
            .memberName("resourceErrors")
            .getter(getter(ResourceErrorsDetails::resourceErrors))
            .setter(setter(Builder::resourceErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HAS_MORE_ERRORS_FIELD,
            RESOURCE_ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean hasMoreErrors;

    private final List<ResourceError> resourceErrors;

    private ResourceErrorsDetails(BuilderImpl builder) {
        this.hasMoreErrors = builder.hasMoreErrors;
        this.resourceErrors = builder.resourceErrors;
    }

    /**
     * <p>
     * This indicates if there are more errors not listed in the <code>resourceErrors</code> list.
     * </p>
     * 
     * @return This indicates if there are more errors not listed in the <code>resourceErrors</code> list.
     */
    public final Boolean hasMoreErrors() {
        return hasMoreErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceErrors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceErrors() {
        return resourceErrors != null && !(resourceErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors retrieving an application's resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceErrors} method.
     * </p>
     * 
     * @return A list of errors retrieving an application's resources.
     */
    public final List<ResourceError> resourceErrors() {
        return resourceErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreErrors());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceErrors() ? resourceErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceErrorsDetails)) {
            return false;
        }
        ResourceErrorsDetails other = (ResourceErrorsDetails) obj;
        return Objects.equals(hasMoreErrors(), other.hasMoreErrors()) && hasResourceErrors() == other.hasResourceErrors()
                && Objects.equals(resourceErrors(), other.resourceErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceErrorsDetails").add("HasMoreErrors", hasMoreErrors())
                .add("ResourceErrors", hasResourceErrors() ? resourceErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hasMoreErrors":
            return Optional.ofNullable(clazz.cast(hasMoreErrors()));
        case "resourceErrors":
            return Optional.ofNullable(clazz.cast(resourceErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceErrorsDetails, T> g) {
        return obj -> g.apply((ResourceErrorsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceErrorsDetails> {
        /**
         * <p>
         * This indicates if there are more errors not listed in the <code>resourceErrors</code> list.
         * </p>
         * 
         * @param hasMoreErrors
         *        This indicates if there are more errors not listed in the <code>resourceErrors</code> list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreErrors(Boolean hasMoreErrors);

        /**
         * <p>
         * A list of errors retrieving an application's resources.
         * </p>
         * 
         * @param resourceErrors
         *        A list of errors retrieving an application's resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceErrors(Collection<ResourceError> resourceErrors);

        /**
         * <p>
         * A list of errors retrieving an application's resources.
         * </p>
         * 
         * @param resourceErrors
         *        A list of errors retrieving an application's resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceErrors(ResourceError... resourceErrors);

        /**
         * <p>
         * A list of errors retrieving an application's resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.ResourceError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.resiliencehub.model.ResourceError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.ResourceError.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceErrors(List<ResourceError>)}.
         * 
         * @param resourceErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.ResourceError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceErrors(java.util.Collection<ResourceError>)
         */
        Builder resourceErrors(Consumer<ResourceError.Builder>... resourceErrors);
    }

    static final class BuilderImpl implements Builder {
        private Boolean hasMoreErrors;

        private List<ResourceError> resourceErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceErrorsDetails model) {
            hasMoreErrors(model.hasMoreErrors);
            resourceErrors(model.resourceErrors);
        }

        public final Boolean getHasMoreErrors() {
            return hasMoreErrors;
        }

        public final void setHasMoreErrors(Boolean hasMoreErrors) {
            this.hasMoreErrors = hasMoreErrors;
        }

        @Override
        public final Builder hasMoreErrors(Boolean hasMoreErrors) {
            this.hasMoreErrors = hasMoreErrors;
            return this;
        }

        public final List<ResourceError.Builder> getResourceErrors() {
            List<ResourceError.Builder> result = ResourceErrorListCopier.copyToBuilder(this.resourceErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceErrors(Collection<ResourceError.BuilderImpl> resourceErrors) {
            this.resourceErrors = ResourceErrorListCopier.copyFromBuilder(resourceErrors);
        }

        @Override
        public final Builder resourceErrors(Collection<ResourceError> resourceErrors) {
            this.resourceErrors = ResourceErrorListCopier.copy(resourceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceErrors(ResourceError... resourceErrors) {
            resourceErrors(Arrays.asList(resourceErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceErrors(Consumer<ResourceError.Builder>... resourceErrors) {
            resourceErrors(Stream.of(resourceErrors).map(c -> ResourceError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResourceErrorsDetails build() {
            return new ResourceErrorsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
