/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the AI-generated summary for the Resilience Hub assessment, providing a concise overview that highlights
 * the top risks and recommendations.
 * </p>
 * <note>
 * <p>
 * This property is available only in the US East (N. Virginia) Region.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssessmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AssessmentSummary.Builder, AssessmentSummary> {
    private static final SdkField<List<AssessmentRiskRecommendation>> RISK_RECOMMENDATIONS_FIELD = SdkField
            .<List<AssessmentRiskRecommendation>> builder(MarshallingType.LIST)
            .memberName("riskRecommendations")
            .getter(getter(AssessmentSummary::riskRecommendations))
            .setter(setter(Builder::riskRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("riskRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssessmentRiskRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssessmentRiskRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUMMARY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("summary")
            .getter(getter(AssessmentSummary::summary)).setter(setter(Builder::summary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RISK_RECOMMENDATIONS_FIELD,
            SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AssessmentRiskRecommendation> riskRecommendations;

    private final String summary;

    private AssessmentSummary(BuilderImpl builder) {
        this.riskRecommendations = builder.riskRecommendations;
        this.summary = builder.summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the RiskRecommendations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRiskRecommendations() {
        return riskRecommendations != null && !(riskRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the top risks and recommendations identified by the Resilience Hub assessment, each representing a
     * specific risk and the corresponding recommendation to address it.
     * </p>
     * <note>
     * <p>
     * This property is available only in the US East (N. Virginia) Region.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRiskRecommendations} method.
     * </p>
     * 
     * @return Indicates the top risks and recommendations identified by the Resilience Hub assessment, each
     *         representing a specific risk and the corresponding recommendation to address it.</p> <note>
     *         <p>
     *         This property is available only in the US East (N. Virginia) Region.
     *         </p>
     */
    public final List<AssessmentRiskRecommendation> riskRecommendations() {
        return riskRecommendations;
    }

    /**
     * <p>
     * Indicates a concise summary that provides an overview of the Resilience Hub assessment.
     * </p>
     * <note>
     * <p>
     * This property is available only in the US East (N. Virginia) Region.
     * </p>
     * </note>
     * 
     * @return Indicates a concise summary that provides an overview of the Resilience Hub assessment.</p> <note>
     *         <p>
     *         This property is available only in the US East (N. Virginia) Region.
     *         </p>
     */
    public final String summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRiskRecommendations() ? riskRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentSummary)) {
            return false;
        }
        AssessmentSummary other = (AssessmentSummary) obj;
        return hasRiskRecommendations() == other.hasRiskRecommendations()
                && Objects.equals(riskRecommendations(), other.riskRecommendations())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssessmentSummary")
                .add("RiskRecommendations", hasRiskRecommendations() ? riskRecommendations() : null).add("Summary", summary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "riskRecommendations":
            return Optional.ofNullable(clazz.cast(riskRecommendations()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssessmentSummary, T> g) {
        return obj -> g.apply((AssessmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssessmentSummary> {
        /**
         * <p>
         * Indicates the top risks and recommendations identified by the Resilience Hub assessment, each representing a
         * specific risk and the corresponding recommendation to address it.
         * </p>
         * <note>
         * <p>
         * This property is available only in the US East (N. Virginia) Region.
         * </p>
         * </note>
         * 
         * @param riskRecommendations
         *        Indicates the top risks and recommendations identified by the Resilience Hub assessment, each
         *        representing a specific risk and the corresponding recommendation to address it.</p> <note>
         *        <p>
         *        This property is available only in the US East (N. Virginia) Region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskRecommendations(Collection<AssessmentRiskRecommendation> riskRecommendations);

        /**
         * <p>
         * Indicates the top risks and recommendations identified by the Resilience Hub assessment, each representing a
         * specific risk and the corresponding recommendation to address it.
         * </p>
         * <note>
         * <p>
         * This property is available only in the US East (N. Virginia) Region.
         * </p>
         * </note>
         * 
         * @param riskRecommendations
         *        Indicates the top risks and recommendations identified by the Resilience Hub assessment, each
         *        representing a specific risk and the corresponding recommendation to address it.</p> <note>
         *        <p>
         *        This property is available only in the US East (N. Virginia) Region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder riskRecommendations(AssessmentRiskRecommendation... riskRecommendations);

        /**
         * <p>
         * Indicates the top risks and recommendations identified by the Resilience Hub assessment, each representing a
         * specific risk and the corresponding recommendation to address it.
         * </p>
         * <note>
         * <p>
         * This property is available only in the US East (N. Virginia) Region.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.AssessmentRiskRecommendation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.AssessmentRiskRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.AssessmentRiskRecommendation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #riskRecommendations(List<AssessmentRiskRecommendation>)}.
         * 
         * @param riskRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.AssessmentRiskRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #riskRecommendations(java.util.Collection<AssessmentRiskRecommendation>)
         */
        Builder riskRecommendations(Consumer<AssessmentRiskRecommendation.Builder>... riskRecommendations);

        /**
         * <p>
         * Indicates a concise summary that provides an overview of the Resilience Hub assessment.
         * </p>
         * <note>
         * <p>
         * This property is available only in the US East (N. Virginia) Region.
         * </p>
         * </note>
         * 
         * @param summary
         *        Indicates a concise summary that provides an overview of the Resilience Hub assessment.</p> <note>
         *        <p>
         *        This property is available only in the US East (N. Virginia) Region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(String summary);
    }

    static final class BuilderImpl implements Builder {
        private List<AssessmentRiskRecommendation> riskRecommendations = DefaultSdkAutoConstructList.getInstance();

        private String summary;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentSummary model) {
            riskRecommendations(model.riskRecommendations);
            summary(model.summary);
        }

        public final List<AssessmentRiskRecommendation.Builder> getRiskRecommendations() {
            List<AssessmentRiskRecommendation.Builder> result = AssessmentRiskRecommendationListCopier
                    .copyToBuilder(this.riskRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRiskRecommendations(Collection<AssessmentRiskRecommendation.BuilderImpl> riskRecommendations) {
            this.riskRecommendations = AssessmentRiskRecommendationListCopier.copyFromBuilder(riskRecommendations);
        }

        @Override
        public final Builder riskRecommendations(Collection<AssessmentRiskRecommendation> riskRecommendations) {
            this.riskRecommendations = AssessmentRiskRecommendationListCopier.copy(riskRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder riskRecommendations(AssessmentRiskRecommendation... riskRecommendations) {
            riskRecommendations(Arrays.asList(riskRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder riskRecommendations(Consumer<AssessmentRiskRecommendation.Builder>... riskRecommendations) {
            riskRecommendations(Stream.of(riskRecommendations)
                    .map(c -> AssessmentRiskRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSummary() {
            return summary;
        }

        public final void setSummary(String summary) {
            this.summary = summary;
        }

        @Override
        public final Builder summary(String summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public AssessmentSummary build() {
            return new AssessmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
